import hildon
from xml.dom import minidom
import pyrecipe_utils

def show_info_banner(widget, msg):
    hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)

class KRecipes:
    def __init__ (self, exp_recipe_list, window, widget):
        for recipe in range(len(exp_recipe_list)):

            title = exp_recipe_list[recipe][1]
            category = exp_recipe_list[recipe][2]
            preptime = exp_recipe_list[recipe][3]
            cooktime = exp_recipe_list[recipe][4]
            servings = exp_recipe_list[recipe][5]
            ingredients = exp_recipe_list[recipe][6]
            instructions = exp_recipe_list[recipe][7]
            notes = exp_recipe_list[recipe][8]
            image = exp_recipe_list[recipe][9]

            if recipe == 0:
                xmldocu = self.write_xml(title, instructions, category,
                            preptime, cooktime, servings, notes, ingredients,
                            image, None)
            else:
                xmldocu = self.write_xml(title, instructions, category,
                            preptime, cooktime, servings, notes, ingredients,
                            image, xmldocu)

        if len(exp_recipe_list) > 1:
            title = 'Recipes'

        namefile = pyrecipe_utils.show_filechooser_dialog(window, 'save',
                        'Save recipe as ', title, 'KRecipes', 'kreml')

        if namefile == None:
            print 'No saving recipe.'
            return

        success = pyrecipe_utils.save_xml_file(namefile, xmldocu)

        if success == True:
            show_info_banner(widget, 'Recipes saved')
        else:
            show_info_banner(widget, 'Error ocurred while exporting the file')


    def write_xml(self, title, instructions, category, preptime, cooktime,
        servings, notes, ingredients, image, xmldocu):

        impl = minidom.getDOMImplementation()
        if xmldocu is None:
            xmldocu = impl.createDocument(None, 'krecipes', None)

        recipe_element = xmldocu.createElement('krecipes-recipe')

        desc_element = xmldocu.createElement('krecipes-description')

        title_element = xmldocu.createElement('title')
        title_element.appendChild(xmldocu.createTextNode(title))

        img_element = xmldocu.createElement('pictures')

        pic_element = xmldocu.createElement('pic')
        pic_element.setAttributeNS("pic", "id", "1")
        pic_element.setAttributeNS("pic", "format", "JPG")

        image = "<![CDATA[" + image.replace('"""', '') + "]]>"

        pic_element.appendChild(xmldocu.createTextNode(image))
        img_element.appendChild(pic_element)


        category_element = xmldocu.createElement('category')
        cats_element = xmldocu.createElement('cat')
        cats_element.appendChild(xmldocu.createTextNode(category))
        category_element.appendChild(cats_element)

        #we change the default time in Pyrecipe to Krecipes format -> 00:00
        #This will be a bug if the time has 'hours' or different format.
        if 'minutes' in preptime:
            preptime = '00:' + preptime.split(" ")[0]

        preptime_element = xmldocu.createElement('preparation-time')
        preptime_element.appendChild(xmldocu.createTextNode(preptime))


        yield_element = xmldocu.createElement('yield')

        servamount_element = xmldocu.createElement('amount')
        servamount_element.appendChild(xmldocu.createTextNode(servings))
        yield_element.appendChild(servamount_element)

        servings_element = xmldocu.createElement('type')
        servings_element.appendChild(xmldocu.createTextNode("Servings"))
        yield_element.appendChild(servings_element)


        desc_element.appendChild(title_element)
        desc_element.appendChild(img_element)
        desc_element.appendChild(category_element)
        desc_element.appendChild(preptime_element)
        desc_element.appendChild(yield_element)


        ing_list_element = xmldocu.createElement('krecipes-ingredients')

        ing_list = pyrecipe_utils.ingredients_to_inglist(ingredients)

        for i in range(len(ing_list)):
            ingredient_element = xmldocu.createElement('ingredient')
            amount_element = xmldocu.createElement('amount')
            amount_element.appendChild(xmldocu.createTextNode(ing_list[i][0]))

            units_element = xmldocu.createElement('unit')
            units_element.appendChild(xmldocu.createTextNode(ing_list[i][1]))

            items_element = xmldocu.createElement('name')
            items_element.appendChild(xmldocu.createTextNode(ing_list[i][2]))

            ingredient_element.appendChild(items_element)
            ingredient_element.appendChild(amount_element)
            ingredient_element.appendChild(units_element)

            ing_list_element.appendChild(ingredient_element)

        instructions_element = xmldocu.createElement('krecipes-instructions')
        instructions_element.appendChild(xmldocu.createTextNode(instructions))

        recipe_element.appendChild(desc_element)
        recipe_element.appendChild(ing_list_element)
        recipe_element.appendChild(instructions_element)

        xmldocu.documentElement.appendChild(recipe_element)

        return xmldocu
