#Import, of course
import sys, time

from libpiano.pandora import Pandora
from PyQt4 import QtCore

class PandaException( Exception ):
	pass

class RadioPlayer(QtCore.QThread): #Main radio class
	__pyqtSignals__ = ( "PlayNext", "LoveHate", "songs", "stations", "deleted", "tired", "authSuccess", \
		"stationCreated", "authFail", "duration", "state(QString)", "seed" )
	
	def __init__( self, Parent=None ):
		self.timer = None
		self.playing = 0
		self.run = 1
		self.user = ""
		self.password = ""
		self.success = 0
		self.duration = 0
		self.position = 0

		self.state = 1
		self.seedSong = 0
		self.getStatlist = 0
		self.getPlaylist = 0
		self.loveHateSong = 0
		self.loveHateRating = False
		self.curSong = 0
		self.tiredSong = 0
		self.startPlay = 0
		self.deleteStation = 0
		self.doAuth = 0
		self.createStationId = 0
		
		self.os = self.get_product()
		if self.os == "RX-51": #Check for N900 or Diablo
			from libpiano.MAFWBackend import MAFWBackend
			self.player = MAFWBackend()
		else:
			from libpiano.OSSOBackend import OSSOBackend
			self.player = OSSOBackend()
		QtCore.QObject.connect(self.player, QtCore.SIGNAL("eof"), self.sigEOF)
		QtCore.QObject.connect(self.player, QtCore.SIGNAL("state_change(int)"), self.stateChange)
		QtCore.QObject.connect(self.player, QtCore.SIGNAL("pos_changed(int,int)"), self.updateTime)
		self.stop = True
		self.playStation = 0
		self.stations = []
		self.curStation = ""
		self.playlist = []

		self.format = 'mp3'
		self.pandora = Pandora( self.format )

		QtCore.QThread.__init__(self)

	def run(self):
		while self.run: #Run a constant loop and see if the main UI class has asked us to do anything
			if self.loveHateSong:
				self.loveHateSong = 0
				self.LoveHate()
				self.loveHateRating = False
			if self.getStatlist:
				self.getStatlist = 0
				self.getStations()
			if self.getPlaylist:
				self.getPlaylist = 0
				self.getMoreSongs()
			if self.startPlay:
				self.startPlay = 0 
				self.playSong( self.curSong )
			if self.tiredSong:
				self.tiredSong = 0
				self.doTired()
			if self.deleteStation:
				self.deleteStation = 0
				self.doDelete()
			if self.doAuth:
				self.doAuth = 0
				self.auth( self.user, self.password )
			if self.createStationId>0:
				self.createStation()
				self.createStationId = 0
			if self.seedSong!=0:
				self.doSeed(self.seedSong)
				self.seedSong = 0

			time.sleep ( 0.5 )

	def get_product( self ): #Find Product ID
		try:                                                               
			lines = open("/proc/component_version", "r").readlines()       
		except:                                                            
			lines = []                                                     
			                                           
		product = "?"                                                      
		for line in lines:                                                 
			line = line.strip()                                            
			if (line.startswith("product")):                               
				parts = line.split()                                       
				product = parts[1].strip()                                 
				break                                                      
		#end for
		return product

	def updateTime( self, pos, total ): #Update position/duration
		if self.playing:
			self.position = pos
			self.duration = total
			#print "%02d:%02d" % divmod(self.duration[1], 60)
			if self.duration > 0:
				self.emit(QtCore.SIGNAL("duration"))

	def stateChange( self, state ): #Update backend state change
		self.state = state
		if state == 2:
			self.emit(QtCore.SIGNAL("state(QString)"),"pause")
		elif state == 1:
			self.emit(QtCore.SIGNAL("state(QString)"),"play")
		elif state == 0:
			self.onPlayBackEnded()

	def createStation( self ): #Create a station at Pandora
		ret = self.pandora.createStation( self.createStationId )
		self.playStation = ret["stationId"]
		self.emit(QtCore.SIGNAL("stationCreated"))

	def search( self, search ): #Search Pandora
		ret = self.pandora.searchPandora( str(search) )
		return ret

	def auth( self, user, password ): #Authenticate to Pandora
		ret = self.pandora.authListener( str(user), str(password) )
		print ret
		if ret:
			self.success = 1
			self.emit(QtCore.SIGNAL("authSuccess"))
		else:
			self.success = 0
			self.emit(QtCore.SIGNAL("authFail"))

	def playSong( self, item ): #Start playing
		self.play( item[0], item[1] )

	def play( self, url, item ): #Load URL/Song into Backend
		self.player.load_audio(url)

	def stopPlayBack ( self,state=None ): #Pause or Stop
		if state == 'pause':
			self.player.pause()
		else:
			if self.os == "RX-51":
				self.player.close()
			else:
				self.player.stop()
				self.onPlayBackEnded()		
	
	def startPlayBack ( self ): #Resume after Pause
		self.player.play()

	def onPlayBackEnded( self ): #EOF Reached, start next song.
		print "EOF called."
		self.emit(QtCore.SIGNAL("PlayNext"))
		
	def sigEOF( self ):
		if self.os != "RX-51":
			self.onPlayBackEnded()

	def LoveHate( self ): #Do Love/Hate based on variable settings
		self.respLH = self.pandora.addFeedback( self.curSong[1]["stationId"], self.curSong, self.loveHateRating )
		self.emit(QtCore.SIGNAL("LoveHate"))

	def doSeed( self, artist=None ):
		if artist == "artist":
			musicId = self.curSong[1]["artistMusicId"]
		else:
			musicId = self.curSong[1]["musicId"]
		respLH = self.pandora.addSeed( self.curSong[1]["stationId"], musicId )
		self.emit(QtCore.SIGNAL("seed"))
		#print respLH

	def doTired( self ): #Mark tired
		respTired = self.pandora.setTired( self.curSong[1]["identity"] )
		print respTired
		self.emit(QtCore.SIGNAL("tired"))

	def doDelete( self ): #Delete station
		respDelete = self.pandora.deleteStation( self.curStation )
		print respDelete
		if respDelete:
			self.emit(QtCore.SIGNAL("deleted"))
			self.getStations()

	def getStations( self ): #Get station list, sort alphabetically.
		self.stations = sorted(self.pandora.getStations(), key=lambda station: station["stationName"])
		self.emit(QtCore.SIGNAL("stations"))

	def getMoreSongs( self ): #Get next 3 or so songs
		if self.curStation == "": #Can't get songs without a station.  This shouldn't happen.
			raise PandaException()
		items = []
		fragment = self.pandora.getFragment( self.curStation, self.format )
		for s in fragment:
			#print s
			#print "\n"
			print s["songTitle"], "by", s["artistSummary"]
			item = None
			item = { "title" : s["songTitle"], \
			"artist"	:	s["artistSummary"], \
			"genre"		:	"".join(s["genre"]), \
			"album"		:	s["albumTitle"], \
			"rating"	:	s["rating"], \
			"art"		: s["artRadio"], \
			"matchingSeed"	: s["matchingSeed"], \
			"userSeed"	: s["userSeed"], \
			"focusTraitId"	: s["focusTraitId"], \
			"stationId"	: s["stationId"], \
			"identity"	: s["identity"], \
			"musicId"	: s["musicId"], \
			"artistMusicId" : s["artistMusicId"] }
			items.append( ( s["audioURL"], item ) )
		self.playlist.extend( items )

	def close( self ): #Close Pandora and Backend
		self.player.stop()
		self.player.close()
		self.player = None
		time.sleep( 1 )
