import sys, time

from libpiano.pandora import Pandora
from PyQt4 import QtCore

class PandaException( Exception ):
	pass

class RadioPlayer(QtCore.QThread):
	__pyqtSignals__ = ( "PlayNext", "LoveHate", "songs", "stations", "deleted", "tired", "authSuccess", \
		"stationCreated", "authFail", "duration", "state(QString)" )
	
	def __init__( self, Parent=None ):
		self.timer = None
		self.playing = 0
		self.skip = False
		self.eof = False
		self.run = 1
		self.user = ""
		self.password = ""
		self.success = 0
		self.duration = 0
		self.position = 0

		self.getStatlist = 0
		self.getPlaylist = 0
		self.loveHateSong = 0
		self.loveHateRating = False
		self.curSong = 0
		self.tiredSong = 0
		self.startPlay = 0
		self.deleteStation = 0
		self.doAuth = 0
		self.createStationId = 0
		
		self.os = self.get_product()
		if self.os == "RX-51":
			from libpiano.MAFWBackend import MAFWBackend
			self.player = MAFWBackend()
		else:
			from libpiano.OSSOBackend import OSSOBackend
			self.player = OSSOBackend()
		QtCore.QObject.connect(self.player, QtCore.SIGNAL("eof"), self.onPlayBackEnded)
		QtCore.QObject.connect(self.player, QtCore.SIGNAL("state_change(int)"), self.stateChange)
		QtCore.QObject.connect(self.player, QtCore.SIGNAL("pos_changed(int,int)"), self.updateTime)
		self.stop = True
		self.playStation = 0
		self.stations = []
		self.curStation = ""
		self.playlist = []

		self.format = 'mp3'
		self.pandora = Pandora( self.format )

		QtCore.QThread.__init__(self)

	def run(self):
		while self.run:
			if self.loveHateSong:
				self.loveHateSong = 0
				self.LoveHate()
				self.loveHateRating = False
			if self.getStatlist:
				self.getStatlist = 0
				self.getStations()
			if self.getPlaylist:
				self.getPlaylist = 0
				self.getMoreSongs()
			if self.startPlay:
				self.startPlay = 0 
				self.playSong( self.curSong )
			if self.tiredSong:
				self.tiredSong = 0
				self.doTired()
			if self.deleteStation:
				self.deleteStation = 0
				self.doDelete()
			if self.doAuth:
				self.doAuth = 0
				self.auth( self.user, self.password )
			if self.createStationId>0:
				self.createStation()
				self.createStationId = 0

			time.sleep ( 0.5 )

	def get_product( self ):
		try:                                                               
			lines = open("/proc/component_version", "r").readlines()       
		except:                                                            
			lines = []                                                     
			                                           
		product = "?"                                                      
		for line in lines:                                                 
			line = line.strip()                                            
			if (line.startswith("product")):                               
				parts = line.split()                                       
				product = parts[1].strip()                                 
				break                                                      
		#end for
		return product

	def updateTime( self, pos, total ):
		if self.playing:
			self.position = pos
			self.duration = total
			#print "%02d:%02d" % divmod(self.duration[1], 60)
			if self.duration > 0:
				self.emit(QtCore.SIGNAL("duration"))

	def stateChange( self, state ):
		if state == 2:
			self.emit(QtCore.SIGNAL("state(QString)"),"pause")
		elif state == 1:
			self.emit(QtCore.SIGNAL("state(QString)"),"play")

	def createStation( self ):
		ret = self.pandora.createStation( self.createStationId )
		self.playStation = ret["stationId"]
		self.emit(QtCore.SIGNAL("stationCreated"))

	def search( self, search ):
		ret = self.pandora.searchPandora( str(search) )
		return ret

	def auth( self, user, password ):
		ret = self.pandora.authListener( str(user), str(password) )
		print ret
		if ret:
			self.success = 1
			self.emit(QtCore.SIGNAL("authSuccess"))
		else:
			self.success = 0
			self.emit(QtCore.SIGNAL("authFail"))

	def playSong( self, item ):
		self.play( item[0], item[1] )

	def play( self, url, item ):
		time.sleep ( 2 )
		self.player.load_audio(url)
		if self.eof:
			self.eof = False

	def stopPlayBack ( self,state=None ):
		if state == 'pause':
			self.player.pause()
		else:
			self.player.stop()
			if self.skip:
				self.onPlayBackStopped()
	
	def startPlayBack ( self ):
		self.player.play()

	def onPlayBackStopped( self ):
		if self.playing:
			if self.skip:
				self.skip = False
				self.emit(QtCore.SIGNAL("PlayNext"))

	def onPlayBackEnded( self ):
		if not self.eof:
			if self.skip:
				self.skip = False
			self.eof = True
			self.emit(QtCore.SIGNAL("PlayNext"))

	def LoveHate( self ):
		self.respLH = self.pandora.addFeedback( self.curSong[1]["stationId"], self.curSong, self.loveHateRating )
		self.emit(QtCore.SIGNAL("LoveHate"))

	def doTired( self ):
		self.respTired = self.pandora.setTired( self.curSong[1]["identity"] )
		print self.respTired
		self.emit(QtCore.SIGNAL("tired"))

	def doDelete( self ):
		self.respDelete = self.pandora.deleteStation( self.curStation )
		print self.respDelete
		if self.respDelete:
			self.emit(QtCore.SIGNAL("deleted"))
			self.getStations()

	def getStations( self ):
		self.stations = self.pandora.getStations()
		self.emit(QtCore.SIGNAL("stations"))

	def getMoreSongs( self ):
		if self.curStation == "":
			raise PandaException()
		items = []
		fragment = self.pandora.getFragment( self.curStation, self.format )
		for s in fragment:
			#print s
			#print "\n"
			item = None
			item = { "title" : s["songTitle"], \
			"artist"	:	s["artistSummary"], \
			"genre"		:	"".join(s["genre"]), \
			"album"		:	s["albumTitle"], \
			"rating"	:	s["rating"], \
			"art"		: s["artRadio"], \
			"matchingSeed"	: s["matchingSeed"], \
			"userSeed"	: s["userSeed"], \
			"focusTraitId"	: s["focusTraitId"], \
			"stationId"	: s["stationId"], \
			"identity"	: s["identity"], \
			"musicId"	: s["musicId"] }
			items.append( ( s["audioURL"], item ) )
		self.playlist.extend( items )

	def close( self ):
		self.player.stop()
		self.player.close()
		self.player = None
		time.sleep( 1 )
