#!/usr/bin/python2.5
import os
import sys,time,re
import osso
import webbrowser
from PyQt4 import QtGui,QtCore
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from pyRadio_ui import *
from pyRadio_ui_portrait import *
from radioplayer import RadioPlayer

import gobject, dbus
from dbus.mainloop.glib import DBusGMainLoop


__title__ = "Pandora"

class snooze(QtCore.QThread):
	__pyqtSignals__ = ( "shutdown" )
	def __init__(self,ktime,cont=None):
		self.ktime = ktime
		self.cont = cont
		QtCore.QThread.__init__(self)
	def run(self):
		time.sleep(self.ktime*60)
		if self.cont:
			self.emit(QtCore.SIGNAL("shutdown"))

class Config:
	def __init__(self):
		self.user = ""
		self.password = ""
		self.color = ""
		self.lastplayed = ""
		self.config_opts = ['user','password']

	def write(self):
		if not os.path.exists(os.path.expanduser("~")+'/.config'):
			os.mkdir(os.path.expanduser("~")+'/.config')

		if not os.path.exists(os.path.expanduser("~")+'/.config/pyradio'):
			os.mkdir(os.path.expanduser("~")+'/.config/pyradio')
		newfile = "user="+self.user+"\npassword="+self.password+"\n"
		f = open(os.path.expanduser("~")+'/.config/pyradio/config', 'w')
		f.write(newfile)
		f.close()

	def load(self):
		if os.path.exists('/etc/hildon/theme/colors.config'):
			f = open('/etc/hildon/theme/colors.config')
			for line in f:
				if re.match("ActiveTextColor\s*=",line):
					self.color = re.match("ActiveTextColor\s*=(.+)",line).group(1).lstrip().rstrip()
				
			if self.color == "":
				self.color = "rgb(255, 255, 255)"

		else:
			self.color = "rgb(255, 255, 255)"
		
		if os.path.exists(os.path.expanduser("~")+'/.config/pyradio/config'):
			f = open(os.path.expanduser("~")+'/.config/pyradio/config', 'r')
			for line in f:
				line = line.replace(" ", "")
				
				if re.match("^#.*",line) is not None:
					continue
				
				for opt in self.config_opts:
					if re.match("^"+opt+"=(.+)$",line) is not None:
						setattr(self,opt,self.get_var(opt,line))
			f.close()

		if os.path.exists(os.path.expanduser("~")+'/.config/pyradio/lastplayed'):
			f = open(os.path.expanduser("~")+'/.config/pyradio/lastplayed', 'r')
			self.lastplayed = f.readline().replace("\n","")
			f.close()

	def get_var(self,var,line):
		r = re.match("^"+var+"=(.+)$",line)
		return r.group(1)
		
class Panda(QtGui.QMainWindow):
	def __init__( self, parent=None ):
		QtGui.QWidget.__init__(self, parent)
		self.ui = None
		self.pandora = None
		self.die = False
		self.authenticated = False
		self.c = Config()
		self.c.load()
		self.player = RadioPlayer()
		self.player.start()
		self.ui = Ui_pyRadio()
		self.ui.setupUi(self)
		if not self.c.lastplayed == "":
			self.player.playStation = self.c.lastplayed
		try :
			self.setAttribute(Qt.WA_Maemo5AutoOrientation, 1)
			self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged );
			print" Auto rotation on"
		except:print "could not autorotate on"
		self.skip = 0
		self.s = snooze(0)
		self.createStations = []
		self.count = 0
		self.connect_signals()
		self.auth()
		try :
			sysbus = dbus.SystemBus()
			self.fmtx = sysbus.get_object('com.nokia.FMTx', '/com/nokia/fmtx/default', False)
			self.fmtx_iface = dbus.Interface(self.fmtx, dbus_interface='org.freedesktop.DBus.Properties')

			state = self.fmtx_iface.Get("com.nokia.FMTx.Device", "state")
			if state == 'enabled':
				self.ui.actionEnable_FM_Radio.setText(QtGui.QApplication.translate("pyRadio", "Disable FM Tx", None, QtGui.QApplication.UnicodeUTF8))
			else:
				self.ui.actionEnable_FM_Radio.setText(QtGui.QApplication.translate("pyRadio", "Enable FM Tx", None, QtGui.QApplication.UnicodeUTF8))
		except: print "Not N900."

	def orientationChanged ( self ):
		screenGeometry=QApplication.desktop().screenGeometry();
		if screenGeometry.width() > screenGeometry.height():
			self.ui = Ui_pyRadio()
			self.ui.setupUi(self)
			self.connect_signals()
			if not self.player.curSong == 0:
				self.setUi ( self.player.curSong )
				self.buildPlaylist()
		else:
			self.ui = Ui_pyRadio_portrait()
			self.ui.setupUi(self)
			self.connect_signals()
			if not self.player.curSong == 0:
				self.setUi ( self.player.curSong )
				self.buildPlaylist()
		print "Orientation Changed"

	def connect_signals( self ):
		if not self.authenticated:
			self.ui.btnPlay.setEnabled( False )
			self.ui.listStations.setEnabled( False )
			self.ui.btnLove.setEnabled( False )
			self.ui.btnHate.setEnabled( False )
			self.ui.btnSleep.setEnabled( False )
			self.ui.btnNext.setEnabled( False )
		QtCore.QObject.connect(self.ui.listStations, QtCore.SIGNAL('activated(int)'), self.playStation)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('pressed()'), self.nextDown)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('released()'), self.nextUp)
		QtCore.QObject.connect(self.ui.btnHate, QtCore.SIGNAL('pressed()'), self.hateDown)
		QtCore.QObject.connect(self.ui.btnHate, QtCore.SIGNAL('released()'), self.hateUp)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('clicked()'), self.skipSong)
		QtCore.QObject.connect(self.ui.btnHate, QtCore.SIGNAL('clicked()'), self.doHate)
		QtCore.QObject.connect(self.ui.btnPlay, QtCore.SIGNAL('clicked()'), self.doPlayPause)
		QtCore.QObject.connect(self.ui.btnLove, QtCore.SIGNAL('clicked()'), self.doLove)
		QtCore.QObject.connect(self.ui.btnSleep, QtCore.SIGNAL('clicked()'), self.tiredSong)
		QtCore.QObject.connect(self.player,QtCore.SIGNAL("PlayNext"), self.playNextSong)
		QtCore.QObject.connect(self.player,QtCore.SIGNAL("LoveHate"), self.sigLoveHate)
		QtCore.QObject.connect(self.player,QtCore.SIGNAL("stations"), self.getStations)
		QtCore.QObject.connect(self.player,QtCore.SIGNAL("deleted"), self.stationDeleted)
		QtCore.QObject.connect(self.player,QtCore.SIGNAL("tired"), self.sigTired)
		QtCore.QObject.connect(self.player,QtCore.SIGNAL("authSuccess"), self.sigAuth)
		QtCore.QObject.connect(self.player,QtCore.SIGNAL("authFail"), self.sigAuth)
		QtCore.QObject.connect(self.player,QtCore.SIGNAL("stationCreated"), self.stationCreated)
		QtCore.QObject.connect(self.s, QtCore.SIGNAL('shutdown'), self.sQuit)
		QtCore.QObject.connect(self.ui.actionUser_Pass, QtCore.SIGNAL('triggered()'), self.setUserPass)
		QtCore.QObject.connect(self.ui.actionDelete, QtCore.SIGNAL('triggered()'), self.deleteStation)
		QtCore.QObject.connect(self.ui.actionEnable_FM_Radio, QtCore.SIGNAL('triggered()'), self.doFM)
		QtCore.QObject.connect(self.ui.actionSnooze, QtCore.SIGNAL('triggered()'), self.setSnooze)
		QtCore.QObject.connect(self.ui.actionCreate, QtCore.SIGNAL('triggered()'), self.createStation)
		QtCore.QObject.connect(self.ui.actionDonate, QtCore.SIGNAL('triggered()'), self.open_donate)

	def open_donate( self ):
		self.d = QDialog(self)
		vbox = QVBoxLayout()
		hLayout = QHBoxLayout()
		m = QPushButton("pyRadio")
		p = QPushButton("Get Pandora One")
		hLayout.addWidget(m)
		hLayout.addWidget(p)
		action = lambda: self.donate('radio')
		action1 = lambda: self.donate('pandora')
		m.clicked.connect(action)
		p.clicked.connect(action1)
		vbox.addLayout(hLayout)
		self.d.setLayout(vbox)
		self.d.setWindowTitle("Donate to:")
		self.d.show()

	def donate( self, who=None ):
		if who == 'radio':		
			webbrowser.open_new('https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=BWX2M54JBJ2T2')
		elif who == 'pandora':
			webbrowser.open_new('http://www.pandora.com/pandora_one')
		self.d.close()

	def stationCreated( self ):
		ok = QtGui.QMessageBox.warning(self,'Station Created','Station Created, your station list will reload.')
		self.ui.listStations.clear()
		self.player.getStatlist = 1
	
	def createStation( self ):
		self.ui.albumArt.setHtml("Please wait..... ")
		station, ok = QtGui.QInputDialog.getText(self,"Artist or Track Name", "Enter an Artist or Track Name:")
		if len(station)>0:
			ret = self.player.search(station)
			if len(ret["artists"])>0 or len(ret["songs"])>0:
				if len(ret["artists"])>0 and len(ret["songs"])>0:
					what = QtGui.QMessageBox.question(self, 'Artist or Track?', 'Is this an artist or track name?','Artist','Track')
					if what == 0:
						songs = ret["artists"]
						title = "artistName"
					else:
						songs = ret["songs"]
						title = "songTitle"
				else:
					if len(ret["artists"])>0:
						songs = ret["artists"]
						title = "artistName"
					else:
						songs = ret["songs"]
						title = "songTitle"

				self.ui.listStations.clear()
				for s in songs:
					self.ui.listStations.addItem(s[title])
					self.createStations = songs

			ok = QtGui.QMessageBox.warning(self,'Select Match','Select the closest title from the station drop down.')

	def stationDeleted( self ):
		ok = QtGui.QMessageBox.warning(self, "Station Deleted", "Station Deleted.")

	def sigTired( self ):
		ok = QtGui.QMessageBox.warning(self, "Tired", "Song marked tired.")
		self.skipSong()

	def deleteStation(self):
		reply = QtGui.QMessageBox.question(self, 'Delete Station',
			"Really delete "+self.ui.listStations.currentText()+"?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
		if reply == QtGui.QMessageBox.Yes:
			self.ui.btnPlay.setStyleSheet("background-color: "+ self.c.color + ";\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/paused-trans.png);")
			self.player.stopPlayBack()
			self.player.deleteStation = 1
			self.ui.albumArt.setHtml("Please wait...")

	def tiredSong(self):
		check = QtGui.QMessageBox.question(self, 'Are you sure?', 'Are you tired of the song ' + self.player.curSong[1]["title"] + '?','No','Yes')
		if check == 1:
			self.player.tiredSong = 1

	def setSnooze(self):
		ktime,ok = QtGui.QInputDialog.getText(self,"Snooze", "Enter a time, in minutes, to shutdown:")
		if ok:
			self.s.cont = 1
			self.s.ktime = int(ktime)
			self.s.start()

	def doFM(self):
		state = self.fmtx_iface.Get("com.nokia.FMTx.Device", "state")
		if state == 'disabled':
			self.ui.actionEnable_FM_Radio.setText(QtGui.QApplication.translate("pyRadio", "Disable FM Tx", None, QtGui.QApplication.UnicodeUTF8))
			self.fmtx_iface.Set("com.nokia.FMTx.Device", "state", dbus.String(u'%s' % 'enabled', variant_level=1))
		else:
			self.ui.actionEnable_FM_Radio.setText(QtGui.QApplication.translate("pyRadio", "Enable FM Tx", None, QtGui.QApplication.UnicodeUTF8))
			self.fmtx_iface.Set("com.nokia.FMTx.Device", "state", dbus.String(u'%s' % 'disabled', variant_level=1))

	def nextDown(self):
		self.ui.btnNext.setStyleSheet("background-color: " + self.c.color + ";\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/skip-trans.png);")

	def nextUp(self):
		self.ui.btnNext.setStyleSheet("background-color: rgb(0, 0, 0);\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/skip-trans.png);")

	def doPlayPause( self ):
		if self.player.playing:
			self.player.stopPlayBack('pause')
			self.player.playing = 0
			self.ui.btnPlay.setStyleSheet("background-color: "+ self.c.color +";\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/paused-trans.png);")
		else:
			self.player.startPlayBack()
			self.player.playing = 1
			self.ui.btnPlay.setStyleSheet("background-color: "+ self.c.color +";\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/playing-trans.png);")

	def doLove( self ):
		self.player.loveHateRating = True
		self.player.loveHateSong = 1
		self.ui.btnLove.setStyleSheet("background-color: "+ self.c.color +";\n"
		"border: rgb(0, 0, 0);\nbackground-image: url(:/img/img/Thumbs-up-right-trans.png);")

	def doHate( self ):
		self.player.loveHateRating = False
		self.player.loveHateSong = 1
		self.skip = 1

	def sigLoveHate( self ):
		if not self.player.respLH:
			self.ui.btnLove.setStyleSheet("background-color: "+ self.c.color +";\n"
			"border: rgb(0, 0, 0);\nbackground-image: url(:/img/img/Thumbs-up-right.png);")
		if self.skip:
			self.skipSong()

	def hateDown(self):
		self.ui.btnHate.setStyleSheet("background-color: " + self.c.color + ";\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/thumbs-down-trans.png);")

	def hateUp(self):
		self.ui.btnHate.setStyleSheet("background-color: rgb(0, 0, 0);\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/thumbs-down-trans.png);")

	def sigAuth( self ):
		if self.player.success:
			self.ui.albumArt.setHtml( "<table width='100%' height='100%'><tr height='100%'><td height='100%' valign='middle'><font style='color: #fff'>Authentication succeeded.  Wait for station list to appear in drop down below and select a station.</font></td><tr></table>" )
			self.player.getStatlist = 1
		else:
			self.ui.albumArt.setHtml( "<table width='100%' height='100%'><tr height='100%'><td height='100%' valign='middle'><font style='color: #fff'>Authentication failed.  Please try again.</font></td><tr></table>" )
			self.c.user = ""
			self.c.password = ""
			self.auth()

	def auth( self ):
		if self.count>2:
			self.sQuit()
		self.count += 1
		if self.c.user == "":
			self.c.user,ok = QtGui.QInputDialog.getText(self,"Username", "Pandora Username:", QLineEdit.Normal)
		if self.c.password == "":
			self.c.password,ok = QtGui.QInputDialog.getText(self,"Password", "Pandora Password:", QLineEdit.Password)
		if self.c.user == "" or self.c.password == "":
			self.auth()
		self.ui.albumArt.setHtml( "<table width='100%' height='100%'><tr height='100%'><td height='100%' valign='middle'><font style='color: #fff'>Authenticating to Pandora as "+self.c.user+" ... </font></td><tr></table>" )
		self.player.user = self.c.user
		self.player.password = self.c.password
		self.player.doAuth = 1
		self.authenticated = True
		self.c.write()

	def playStation( self ):
		if len(self.createStations)>0:
			self.player.createStationId = self.createStations[self.ui.listStations.currentIndex()]['musicId']
			self.createStations = []
			return

		if self.player.playing:
			self.player.stopPlayBack()
		
		if self.player.playStation > 0:
			stationId = self.player.playStation
			self.player.playStation = 0
		else:
			stationId = self.player.stations[self.ui.listStations.currentIndex()]['stationId']	
		self.player.curStation = stationId
		self.player.playlist = []
		self.player.getMoreSongs()
		self.player.playing = True
		self.playNextSong()
		if stationId != self.c.lastplayed:
			f = open(os.path.expanduser("~")+'/.config/pyradio/lastplayed', 'w')
			f.write(self.player.curStation)
			f.close()

	def getStations( self ):	
		self.count = 0
		self.ui.listStations.clear()
		self.ui.btnPlay.setEnabled( True )
		self.ui.listStations.setEnabled( True )
		self.ui.btnLove.setEnabled( True )
		self.ui.btnHate.setEnabled( True )
		self.ui.btnSleep.setEnabled( True )
		self.ui.btnNext.setEnabled( True )

		self.buildPlaylist()

		if self.player.playStation > 0:
			self.playStation()

	def buildPlaylist( self ):
		for s in self.player.stations:
			if s["isQuickMix"]:
				qMixIds = s["quickMixStationIds"]
				break

		for s in self.player.stations:
			#print s
			#print ""
			sName = s["stationName"]
			for qMixId in qMixIds:
				if qMixId == s["stationId"]:
					sName += " *"
			self.ui.listStations.addItem(sName)
			if self.player.playStation>0 and s["stationId"] == self.player.playStation:
				self.ui.listStations.setCurrentIndex(self.ui.listStations.count()-1)	

	def setUserPass( self ):
		self.c.user = ""
		self.c.password = ""
		self.auth()

	def playNextSong( self ):
		if not self.player.playing:
			raise PandaException()
		while self.player.playlist == []:
			self.player.getPlaylist = 1
			time.sleep( 0.5 )
		next = self.player.playlist.pop( 0 )
		self.player.curSong = next
		self.player.startPlay = 1
		self.setUi ( next )
		if len( self.player.playlist ) == 0:
			#Out of songs, grab some more while playing
			self.player.getPlaylist = 1
	
	def setUi ( self, next=None ):
		art = next[1]["art"]
		self.ui.albumArt.setHtml("<img style='width: 100%; height: 95%' src='"+art+"'>")
		self.ui.lblAlbum.setText("\"" + next[1]["title"] + "\"" + " by " + next[1]["artist"] + "\n" + "on: " + next[1]["album"])
		#self.setWindowTitle(QtGui.QApplication.translate("pyRadio", "\"" + next[1]["title"] + "\"" + " by " + next[1]["artist"] + " - pyRadio", None, QtGui.QApplication.UnicodeUTF8))
		#self.ui.lblAlbum.setText("on: " + next[1]["album"])
		if next[1]["rating"] > 0:
			self.ui.btnLove.setStyleSheet("background-color: "+ self.c.color + ";\n"
			"border: rgb(0, 0, 0);\nbackground-image: url(:/img/img/Thumbs-up-right-trans.png);")
		else:
			self.ui.btnLove.setStyleSheet("background-image: url(:/img/img/Thumbs-up-right-trans.png);\nborder: rgb(0, 0, 0);\nbackground-color: rgb(0, 0, 0);")

		self.ui.btnPlay.setStyleSheet("background-image: url(:/img/img/playing-trans.png);\nborder: rgb(0, 0, 0);\nbackground-color: "+ self.c.color + ";")

	def skipSong( self ):
		self.player.skip = True
		self.player.stopPlayBack()
		self.player.onPlayBackStopped()

	def stop( self ):
		self.player.playing = False

	def sQuit( self ):
		self.player.skip = False
		if self.player.playing:
			self.player.playing = False
			self.player.stopPlayBack()
		self.player.run = 0
		del self.ui
		del self.player
		quit()

if __name__ == '__main__':
	if not ( os.path.exists( os.path.dirname(sys.argv[0])+"/libpiano/crypt_key_input.h" ) \
			and os.path.exists( os.path.dirname(sys.argv[0])+"/libpiano/crypt_key_output.h" ) ):
		ok = QtGui.QMessageBox.warning(None, "Pandora", "Missing encription key files." )
	else:
		app = QtGui.QApplication(sys.argv)
		panda = Panda()
		panda.show()
		sys.exit(app.exec_())
