import gobject, sys, time

import pygst
pygst.require('0.10')
import gst

from libpiano.pandora import Pandora
from PyQt4 import QtCore

class PandaException( Exception ):
	pass

class RadioPlayer(QtCore.QThread):
	__pyqtSignals__ = ( "PlayNext", "LoveHate", "songs", "stations", "deleted", "tired", "authSuccess", \
		"stationCreated", "authFail" )
	
	def __init__( self, Parent=None ):
		self.timer = None
		self.playing = 0
		self.skip = False
		self.run = 1
		self.user = ""
		self.password = ""
		self.success = 0

		self.getStatlist = 0
		self.getPlaylist = 0
		self.loveHateSong = 0
		self.loveHateRating = False
		self.curSong = 0
		self.tiredSong = 0
		self.startPlay = 0
		self.deleteStation = 0
		self.doAuth = 0
		self.createStationId = 0
		
		self.playStation = 0
		self.stations = []
		self.curStation = ""
		self.playlist = []

		fmt = 'mp3'
		self.pandora = Pandora( fmt )

		QtCore.QThread.__init__(self)

	def run(self):
		self.pandora.sync()
		self.player = gst.element_factory_make("playbin2", "player")
		fakesink = gst.element_factory_make("fakesink", "fakesink")
		self.player.set_property("video-sink", fakesink)
		self.player.set_property("buffer-size", 512000)
		#self.player.set_property("buffer-duration", 512000)
		#self.bin = gst.parse_launch('playbin2 name=source')
						#'uridecodebin name=uridecode ! ' +
						#'volume name=volume ! ' +
						#'speed name=speed ! ' +
						#'audioresample ! ' +
						#'pulsesink name=pulsesink')
		#self.player = self.bin.get_by_name('source')
		bus = self.player.get_bus()
		bus.add_signal_watch()
		bus.connect("message::eos", self.onPlayBackEnded)
		bus.connect("message", self.on_message)
		loop = gobject.MainLoop()
		gobject.threads_init()
		context = loop.get_context()
		while self.run:
			if self.loveHateSong:
				self.loveHateSong = 0
				self.LoveHate()
				self.loveHateRating = False
			if self.getStatlist:
				self.getStatlist = 0
				self.getStations()
			if self.getPlaylist:
				self.getPlaylist = 0
				self.getMoreSongs()
			if self.startPlay:
				self.startPlay = 0 
				self.playSong( self.curSong )
			if self.tiredSong:
				self.tiredSong = 0
				self.doTired()
			if self.deleteStation:
				self.deleteStation = 0
				self.doDelete()
			if self.doAuth:
				self.doAuth = 0
				self.auth( self.user, self.password )
			if self.createStationId>0:
				self.createStation()
				self.createStationId = 0

			time.sleep ( 0.5 )

	def createStation( self ):
		ret = self.pandora.createStation( self.createStationId )
		self.playStation = ret["stationId"]
		self.emit(QtCore.SIGNAL("stationCreated"))

	def search( self, search ):
		ret = self.pandora.searchPandora( str(search) )
		return ret

	def auth( self, user, password ):
		ret = self.pandora.authListener( str(user), str(password) )
		print ret
		if ret:
			self.success = 1
			self.emit(QtCore.SIGNAL("authSuccess"))
		else:
			self.success = 0
			self.emit(QtCore.SIGNAL("authFail"))

	def playSong( self, item ):
		self.play( item[0], item[1] )

	def play( self, url, item ):
		self.player.set_property('uri', url)
		time.sleep( 3 )
		self.player.set_state(gst.STATE_PLAYING)

	def stopPlayBack ( self,state=None ):
		if state == 'pause':
			self.player.set_state(gst.STATE_PAUSED)
		else:
			self.player.set_state(gst.STATE_NULL)
	
	def startPlayBack ( self ):
		self.player.set_state(gst.STATE_PLAYING)

	def onPlayBackStopped( self ):
		if self.playing:
			if self.skip:
				self.skip = 0
			self.emit(QtCore.SIGNAL("PlayNext"))

	def onPlayBackEnded( self, bus, msg ):
		if self.playing:
			if self.skip:
				self.skip = 0
			self.player.set_state(gst.STATE_NULL)
			self.emit(QtCore.SIGNAL("PlayNext"))

	def LoveHate( self ):
		self.respLH = self.pandora.addFeedback( self.curSong[1]["stationId"], self.curSong, self.loveHateRating )
		self.emit(QtCore.SIGNAL("LoveHate"))

	def doTired( self ):
		self.respTired = self.pandora.setTired( self.curSong[1]["identity"] )
		print self.respTired
		self.emit(QtCore.SIGNAL("tired"))

	def doDelete( self ):
		self.respDelete = self.pandora.deleteStation( self.curStation )
		print self.respDelete
		if self.respDelete:
			self.emit(QtCore.SIGNAL("deleted"))
			self.getStations()

	def getStations( self ):
		self.stations = self.pandora.getStations()
		self.emit(QtCore.SIGNAL("stations"))

	def getMoreSongs( self ):
		if self.curStation == "":
			raise PandaException()
		items = []
		fragment = self.pandora.getFragment( self.curStation )
		for s in fragment:
			#print s
			#print "\n"
			item = { "title" : s["songTitle"], \
			"artist"	:	s["artistSummary"], \
			"genre"		:	"".join(s["genre"]), \
			"album"		:	s["albumTitle"], \
			"rating"	:	s["rating"], \
			"art"		: s["artistArtUrl"], \
			"matchingSeed"	: s["matchingSeed"], \
			"userSeed"	: s["userSeed"], \
			"focusTraitId"	: s["focusTraitId"], \
			"stationId"	: s["stationId"], \
			"identity"	: s["identity"], \
			"musicId"	: s["musicId"] }
			items.append( ( s["audioURL"], item ) )
		self.playlist.extend( items )
	
	def on_message( self, bus, msg ):
		#print msg
		return
