#!/usr/bin/env python2.5 
   
import gtk
import hildon
import sys
import PrayerTime 
import GPSPrayerLocator
import thread
import time
import mythread
import gobject
import datetime
import dbus

gobject.threads_init()

class prayertimeGTK:

    def main(self):
         self.tz = "0"
         self.lng = "0"
         self.lat = "0"
         self.loc = "None"
         
         
         program = hildon.Program.get_instance()
         
         # Create the main window
         win = hildon.StackableWindow()
         

         win.set_title("Main window")
         menu = self.create_menu()
       
           # Attach menu to the window
         win.set_app_menu(menu)
         
         self.gtkwin = win    
     
         button = gtk.Button("Go to subview")
         #win.add(button)
         self.pan = hildon.PannableArea()
         self.names = ['Fajr', 'Shorooq', 'Zohr', 'Asr', 'Maghrab','sunset', 'Eshaa']
         
         self.prayerTime = PrayerTime.Calculation() 
         self.loadSettings()
         print self.mode
         if(self.mode == None or self.mode == "None"):
            times = self.prayerTime.calculate()
         elif(self.mode == "GPS"):
            #a= "z"
            locator = GPSPrayerLocator.GPSPrayerLocator()
            locator.locate(self.refresh)
         elif(self.mode == "MAN"):
            times = self.prayerTime.calculate(int(self.tz),float(self.lat),float(self.lng))
         self.vbox = gtk.VBox()
         self.times = times
         header = gtk.Label("PrayerTimes")
         self.vbox.pack_start(header)
         self.prayerTab = self.create_layout_tab(times,self.names)
         self.vbox.pack_start(self.prayerTab)
         #self.pan.add_with_viewport(self.vbox)
         win.add(self.vbox)
                  
     
         win.connect("destroy", gtk.main_quit, None)
         # This call show the window and also add the window to the stack
         win.show_all()
         gtk.main()
         print 'out main'
         
    def getNextPrayer(self):
      for i in xrange(len(self.times)):
        if self.times[i] >= datetime.datetime.now().time():
          return i
      print self.times[0]
      print datetime.datetime.now().time()
      print 'No Next'
      return 0
    

    def formatTime(self,time):
        return self.twoDigitsFormat(time.hour)+':'+ self.twoDigitsFormat(time.minute);
        
    def twoDigitsFormat(self,num):
            if(num < 10):
                return "0" + str(int(num))
            return str(int(num))

    def create_layout_tab(self,times,names):
        table = gtk.Table(2,3)
        j = 0 
        for i in xrange(0,7):
          label1 = gtk.Label(names[i])
          label2 = gtk.Label(self.formatTime(times[i]))
          table.attach(label1,0,1,i,i+1)
          table.attach(label2,1,2,i,i+1)
        return table
     
    def create_menu(self):
        menu = hildon.AppMenu()        
        button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        command_id = "Location Settings"
        button.set_label(command_id)
        button.connect("clicked", self.show_settings_window)
        menu.append(button)
        
        button = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        command_id = "GPS"
        button.set_label(command_id)

        button.connect("clicked", self.saveGPS)
        
        menu.append(button)
        
        
        button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        command_id = "Hide"
        button.set_label(command_id)
        button.connect("clicked", self.hideTest)
        menu.append(button)
        
        menu.show_all()
        
        return menu
    
    def hideTest(self,widget):
          if hasattr(self,'tt'):
               self.tt = None
          self.nextPrayerIndex = self.getNextPrayer()
          print self.nextPrayerIndex
          if self.nextPrayerIndex == None:
               secondsTillTomorrow = 24*3600 - toSeconds(datetime.datetime.now().time())
               sleeptime = toSeconds(self.times[0])+secondsTillTomorrow
               self.nextPrayerIndex = 0
          else:
               sleeptime = diffTime(self.times[self.nextPrayerIndex],datetime.datetime.now().time())
          print sleeptime
          self.tt = mythread.notifier(self,sleeptime)
          self.tt.start()
          self.tt=None
          self.gtkwin.hide()
          print 'thread should be running'
        
    def showTest(self):
        self.gtkwin.show_all()
        banner = hildon.hildon_banner_show_information(self.gtkwin, " ", "It is Time for: "+self.names[self.nextPrayerIndex])

    def show_settings_window(self,widget):
           # Create the main window
           win = hildon.StackableWindow()
           win.set_title("Settings")
           vbox = gtk.VBox(False, 0)
           
           self.entryLoc = hildon.Entry(gtk.HILDON_SIZE_AUTO)
           self.entryLoc.set_placeholder("Location Name")
           label = gtk.Label("Location")
           hbox = gtk.HBox()
           hbox.pack_start(label)
           hbox.pack_start(self.entryLoc)
           vbox.pack_start(hbox, True, True, 0)
           
           self.entryLat = hildon.Entry(gtk.HILDON_SIZE_AUTO)
           self.entryLat.set_placeholder("Latitude")
           label = gtk.Label("Latitude")
           hbox = gtk.HBox()
           hbox.pack_start(label)
           hbox.pack_start(self.entryLat)
           vbox.pack_start(hbox, True, True, 0)
           
           self.entryLong = hildon.Entry(gtk.HILDON_SIZE_AUTO)
           self.entryLong.set_placeholder("Longtude")
           label = gtk.Label("Longtude")
           hbox = gtk.HBox()
           hbox.pack_start(label)
           hbox.pack_start(self.entryLong)
           vbox.pack_start(hbox, True, True, 0)
           
           self.entryTZ = hildon.Entry(gtk.HILDON_SIZE_AUTO)
           self.entryTZ.set_placeholder("TimeZone")
           label = gtk.Label("timezone")
           hbox = gtk.HBox()
           hbox.pack_start(label)
           hbox.pack_start(self.entryTZ)
           vbox.pack_start(hbox, True, True, 0)
       
           self.loadSettings()
           
           self.entryLoc.set_text(self.loc)
           self.entryLat.set_text(self.lat)
           self.entryLong.set_text(self.lng)
           self.entryTZ.set_text(self.tz)
           
           button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                                  hildon.BUTTON_ARRANGEMENT_VERTICAL)
       
           # Set labels value
           button.set_text("Save", "apply Settings")
           
           vbox.pack_start(button, True, True, 0)
           
           button.connect("clicked", self.saveSettings)
           
           win.add(vbox)
       
           # This call show the window and also add the window to the stack
           win.show_all()
           self.settingsWin = win

           

    def loadSettings(self):
        self.mode = "None"
        settingsFile = open('/opt/pyprayertime/settings', 'r')
        val = settingsFile.readline()
        if (val == ""):
            return None
        if(val == "1"):
            self.mode = "GPS"
    
        val = settingsFile.readline()
        if (val == ""):
            return None
        self.loc = val[0:len(val)-1];
        
        
        val = settingsFile.readline()
        if (val == ""):
            return None
        self.lat = val[0:len(val)-1]
        
        
        val = settingsFile.readline()
        if (val == ""):
            return None
        self.lng = val[0:len(val)-1]
        
        
        val = settingsFile.readline()
        if (val == ""):
            return None
        self.tz = val[0:len(val)-1]
        
        
        
        self.mode="MAN"


    def on_page_switch(self,notebook, page, num, dialog):
         print >>sys.stderr, "Page %d" % num
         return True
     
    def some_page_func(self,nb, current, userdata):
         # Validate data only for the third page.
         if current == 2:
             entry = nb.get_nth_page(current)
             return len(entry.get_text()) != 0
         else:
             return True
     
    def saveSettings(self,x):
        self.fileLocation = "/opt/pyprayertimes/"
        settingsFile = open('/opt/pyprayertime/settings', 'w')
        settingsFile.write("0\n")
        settingsFile.write(self.entryLoc.get_text()+"\n")
        settingsFile.write(self.entryLat.get_text()+"\n")
        settingsFile.write(self.entryLong.get_text()+"\n")
        settingsFile.write(self.entryTZ.get_text()+"\n")
        self.refresh(self.entryTZ.get_text(),self.entryLat.get_text(),self.entryLong.get_text())
        self.settingsWin.hide()
        banner = hildon.hildon_banner_show_information(self.gtkwin, " ", "done saving")
    
    def saveGPS(self,x):
        
        self.fileLocation = "/opt/pyprayertimes/"
        settingsFile = open('/opt/pyprayertime/settings', 'w')
       
        if(x.get_active()):
            settingsFile.write("1\n")
            locator = GPSPrayerLocator.GPSPrayerLocator()
            locator.locate(self.refresh)
        else:
            settingsFile.write("0\n")
        settingsFile.write(str(self.loc)+"\n")
        settingsFile.write(str(self.lat)+"\n")
        settingsFile.write(str(self.lng)+"\n")
        settingsFile.write("0\n")
        
    
    def refresh(self,tz,lat,lng):
        self.vbox.remove(self.prayerTab)
        self.tz = tz
        self.lng = lng
        self.lat = lat
        times = self.prayerTime.calculate(int(self.tz),float(self.lat),float(self.lng))
        self.prayerTab = self.create_layout_tab(times,self.names)
        self.vbox.pack_start(self.prayerTab)
        self.vbox.show_all()
        #self.pan.remove(self.vbox)
        #self.pan.redraw(True)
        banner = hildon.hildon_banner_show_information(self.gtkwin, " ", "done getting prayer for "+str(self.lat)+":"+str(self.lng))
   

def diffTime(time1,time2):
	ss = 0
	ss = time1.hour*3600 - time2.hour*3600
	ss +=  (time1.minute-time2.minute)*60
	ss = ss + time1.second - time2.second
	return ss
def toSeconds(time1):
     ss = ime1.hour*3600+time1.minute*60+time1.second
     return ss

def showTest():
  while 1:
        print 'in thread'
        time.sleep(2)
        print 'out thread'

if __name__ == "__main__":
     ui = prayertimeGTK()
     ui.main()
