/*
 The contents of this file are subject to the Mozilla Public License        
 Version 1.1 (the "License"); you may not use this file except in           
 compliance with the License. You may obtain a copy of the License at       
 http://www.mozilla.org/MPL/                                                
                                                                            
 Software distributed under the License is distributed on an "AS IS"        
 basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the    
 License for the specific language governing rights and limitations         
 under the License.                                                         
                                                                            
 Alternatively, the contents of this file may be used under the terms       
 of the GNU Lesser General Public license (the  "LGPL License"), in which case the  
 provisions of LGPL License are applicable instead of those                  
 above.                                                                     
                                                                            
 For feedback and questions about my Files and Projects please mail me,     
 Alexander Matthes (Ziz) , zizsdl_at_googlemail.com                         
*/
#ifndef _MESHLOADER_H
#define _MESHLOADER_H
#include "3dengine.h"

typedef struct smesh *pmesh;
typedef struct smesh {
  int vcount;
  ppoint verticies;
  int qcount;
  pquad quads;
  int tcount;
  ptriangle triangles;
} tmesh;

tpoint readOBJVString(char* string);

tquad readOBJQString(char* string);

ttriangle readOBJTString(char* string);

pmesh loadMesh(char* filename);

void drawMesh(pmesh mesh,Uint16 color);

void drawMeshXYZ(Sint32 x,Sint32 y,Sint32 z,pmesh mesh,Uint16 color);

void drawMeshXYZS(Sint32 x,Sint32 y,Sint32 z,Sint32 s,pmesh mesh,Uint16 color);

void freeMesh(pmesh mesh);

#endif
