/*
 The contents of this file are subject to the Mozilla Public License        
 Version 1.1 (the "License"); you may not use this file except in           
 compliance with the License. You may obtain a copy of the License at       
 http://www.mozilla.org/MPL/                                                
                                                                            
 Software distributed under the License is distributed on an "AS IS"        
 basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the    
 License for the specific language governing rights and limitations         
 under the License.                                                         
                                                                            
 Alternatively, the contents of this file may be used under the terms       
 of the GNU Lesser General Public license (the  "LGPL License"), in which case the  
 provisions of LGPL License are applicable instead of those                  
 above.                                                                     
                                                                            
 For feedback and questions about my Files and Projects please mail me,     
 Alexander Matthes (Ziz) , zizsdl_at_googlemail.com                         
*/
#include "graphicstuff.h"

Sint32 projectionMatrix[16];
Sint32 modellViewMatrix[16];
Sint32 cosvalue[(2*MY_PI)>>COS_ACCURACY];
int engineWindowX;
int engineWindowY;
int* letterSpacing = NULL;

void setLetterSpacing(int* point0r)
{
  letterSpacing = point0r;
}

#ifndef ARMCPU
int fpdiv(int numerator,int denominator)
{
  return ((numerator<<HALF_ACCURACY)/denominator)<<HALF_ACCURACY;
}
#endif

Sint32* engineGetProjectionMatrix()
{
  return projectionMatrix;
}

Sint32* engineGetModellViewMatrix()
{
  return modellViewMatrix;
}

void engineSetWindowX(int x)
{
  engineWindowX=x;
  engineSetWindowXasm(x);
}

int engineGetWindowX()
{
  return engineWindowX;
}

void engineSetWindowY(int y)
{
  engineSetWindowYasm(y);
  engineWindowY=y;
}

int engineGetWindowY()
{
  return engineWindowY;
}

void initMath()
{
  int a;
  for (a=0;a<((MY_PI<<1)>>COS_ACCURACY);a++)
    cosvalue[a]=(Sint32)(cos((float)(a<<COS_ACCURACY)/ACCURACY_FACTOR)*ACCURACY_FACTOR);
}

Sint32 mycos(Sint32 w)
{
  return cosvalue[(abs(w)%(MY_PI<<1))>>COS_ACCURACY];
  //return (Sint32)(cos((float)w/ACCURACY_FACTOR)*ACCURACY_FACTOR);
}

Sint32 mysin(Sint32 w)
{
  return mycos(w+((3*MY_PI)>>1));
}

//senquack - credit for this fast sqrt goes to Wilco Dijkstra http://www.finesse.demon.co.uk/steven/sqrt.html
#define iter1(N) \
    try = root + (1 << (N)); \
    if (n >= try << (N))   \
    {   n -= try << (N);   \
        root |= 2 << (N); \
    }

Sint32 fpsqrt (Sint32 n)
{
    Sint32 root = 0, try;
    iter1 (15);    iter1 (14);    iter1 (13);    iter1 (12);
    iter1 (11);    iter1 (10);    iter1 ( 9);    iter1 ( 8);
    iter1 ( 7);    iter1 ( 6);    iter1 ( 5);    iter1 ( 4);
    iter1 ( 3);    iter1 ( 2);    iter1 ( 1);    iter1 ( 0);
    return root << (HALF_ACCURACY-1);
}

void setModellViewMatrixIdentity()
{
  modellViewMatrix[ 0] = 1<<ACCURACY;
  modellViewMatrix[ 1] = 0<<ACCURACY;
  modellViewMatrix[ 2] = 0<<ACCURACY;
  modellViewMatrix[ 3] = 0<<ACCURACY;
  modellViewMatrix[ 4] = 0<<ACCURACY;
  modellViewMatrix[ 5] = 1<<ACCURACY;
  modellViewMatrix[ 6] = 0<<ACCURACY;
  modellViewMatrix[ 7] = 0<<ACCURACY;
  modellViewMatrix[ 8] = 0<<ACCURACY;
  modellViewMatrix[ 9] = 0<<ACCURACY;
  modellViewMatrix[10] = 1<<ACCURACY;
  modellViewMatrix[11] = 0<<ACCURACY;
  modellViewMatrix[12] = 0<<ACCURACY;
  modellViewMatrix[13] = 0<<ACCURACY;
  modellViewMatrix[14] = 0<<ACCURACY;
  modellViewMatrix[15] = 1<<ACCURACY;
}

Uint16 getRGB(Uint8 r,Uint8 g,Uint8 b)
{
  return ((r>>3)<<11)+((g>>2)<<5)+(b>>3);
}

Uint16 getHSV(Sint32 h,Uint8 s,Uint8 v)
{
  h=h%(2*MY_PI);
  Uint8 hi = fpdiv(3*h,MY_PI)>>ACCURACY;//((h<<HALF_ACCURACY)/(MY_PI/3))>>HALF_ACCURACY;
  Sint32 f = fpdiv(3*h,MY_PI)-(hi<<ACCURACY);
  Sint32 p = (v<<(HALF_ACCURACY-8))*((1<<HALF_ACCURACY)-(s<<(HALF_ACCURACY-8)));
  Sint32 q = (v<<(HALF_ACCURACY-8))*((1<<HALF_ACCURACY)-(((f>>HALF_ACCURACY)*(s<<(HALF_ACCURACY-8)))>>HALF_ACCURACY));
  Sint32 t = (v<<(HALF_ACCURACY-8))*((1<<HALF_ACCURACY)-((((1<<HALF_ACCURACY)-(f>>HALF_ACCURACY))*(s<<(HALF_ACCURACY-8)))>>HALF_ACCURACY));
  Uint8 r;
  Uint8 g;
  Uint8 b;
  switch (hi)
  {
    case 1:
      r=q>>(ACCURACY-8);
      g=v; 
      b=p>>(ACCURACY-8);
      break;
    case 2:
      r=p>>(ACCURACY-8);
      g=v; 
      b=t>>(ACCURACY-8);
      break;
    case 3:
      r=p>>(ACCURACY-8);
      g=q>>(ACCURACY-8); 
      b=v;
      break;
    case 4:
      r=t>>(ACCURACY-8);
      g=p>>(ACCURACY-8); 
      b=v;
      break;
    case 5:
      r=v;
      g=p>>(ACCURACY-8); 
      b=q>>(ACCURACY-8);
      break;
    default:
      r=v;
      g=t>>(ACCURACY-8); 
      b=p>>(ACCURACY-8);
      break;
  }
  return ((r>>3)<<11)+((g>>2)<<5)+(b>>3);
}

void drawtext(SDL_Surface *screen,Sint32 x,Sint32 y,char* text,SDL_Surface *keymap)
{
  int p=0;
  while (text[p]!=0 /*&& x<engineWindowX*/)
  {
    unsigned char c = text[p]-32;
    SDL_Rect srcrect;
    srcrect.x=(c % 16)*(keymap->w >> 4);
    srcrect.y=(c >> 4)*(keymap->h >> 3);
    if (letterSpacing == NULL)
      srcrect.w=keymap->w >> 4;
    else
      srcrect.w=letterSpacing[c];
    srcrect.h=keymap->h >> 3;
    SDL_Rect dstrect;
    dstrect.x=x;
    dstrect.y=y;
    dstrect.w=srcrect.w;
    dstrect.h=srcrect.h;
    
    SDL_BlitSurface(keymap, &srcrect, screen, &dstrect);
    x+=srcrect.w;
    p++;
  }
}

int getTextLength(char* text,SDL_Surface* keymap)
{
  int p=0;
  int x=0;
  while (text[p]!=0 /*&& x<engineWindowX*/)
  {
    unsigned char c = text[p]-32;
    if (letterSpacing == NULL)
      x+=keymap->w >> 4;
    else
      x+=letterSpacing[c];
    p++;
  }
  return x;
}

void drawtextMX(SDL_Surface *screen,Sint32 x,Sint32 y,char* text,SDL_Surface *keymap)
{
  drawtext(screen,x-getTextLength(text,keymap)/2,y,text,keymap);
}

void drawtextMY(SDL_Surface *screen,Sint32 x,Sint32 y,char* text,SDL_Surface *keymap)
{
  drawtext(screen,x,y-(keymap->h >> 4),text,keymap);
}

void drawtextMXMY(SDL_Surface *screen,Uint16 x,Uint16 y,char* text,SDL_Surface *keymap)
{
  drawtext(screen,x-getTextLength(text,keymap)/2,y-(keymap->h >> 4),text,keymap);
}

void setFrustumf2(Sint32 *matrix, Sint32 left, Sint32 right, Sint32 bottom, Sint32 top,
                  Sint32 znear, Sint32 zfar)
{
    Sint32 temp, temp2, temp3, temp4;
    temp = 2 * znear;
    temp2 = right - left;
    temp3 = top - bottom;
    temp4 = zfar - znear;
    matrix[0] = fpdiv(temp,temp2);
    matrix[1] = 0<<ACCURACY;
    matrix[2] = 0<<ACCURACY;
    matrix[3] = 0<<ACCURACY;
    matrix[4] = 0<<ACCURACY;
    matrix[5] = fpdiv(temp,temp3);
    matrix[6] = 0<<ACCURACY;
    matrix[7] = 0<<ACCURACY;
    matrix[8] = fpdiv(right + left,temp2);
    matrix[9] = fpdiv(top + bottom,temp3);
    matrix[10] = fpdiv(-zfar - znear,temp4);
    matrix[11] = -1<<ACCURACY;
    matrix[12] = 0<<ACCURACY;
    matrix[13] = 0<<ACCURACY;
    matrix[14] = fpdiv((-temp >> HALF_ACCURACY) * (zfar >> HALF_ACCURACY),temp4);
    matrix[15] = 0<<ACCURACY;
}

void setPerspective(float fovyInDegrees, float aspectRatio,
                      float znear, float zfar)
{
    float ymax, xmax;
    ymax = znear * tanf(fovyInDegrees * M_PI / 360.0);
    //ymin = -ymax;
    //xmin = -ymax * aspectRatio;
    xmax = ymax * aspectRatio;
    setFrustumf2(projectionMatrix,(Sint32)(-xmax*ACCURACY_FACTOR),
                                  (Sint32)(xmax*ACCURACY_FACTOR),
                                  (Sint32)(-ymax*ACCURACY_FACTOR),
                                  (Sint32)(ymax*ACCURACY_FACTOR),
                                  (Sint32)(znear*ACCURACY_FACTOR),
                                  (Sint32)(zfar*ACCURACY_FACTOR));
}


#ifndef ARMCPU
#ifndef X86CPU   
void hline(Uint16* pixel,Sint32 x,Sint32 y,Sint32 l_,Uint16 color_,char check)
{
  //l_++;
  if (check)
  { 
    if (y<0)
      return;
    if (y>=engineWindowY) //Their is a FUCKING Bug if I write in the last line on the gp2x. Dont know why...
      return;
    if (x<0)
    {
      l_=x+l_;
      x=0;
    }
    if (x+l_>=engineWindowX)
      l_=engineWindowX-x;
    if (l_<=0)
      return;
  }
  Uint32 pos=(x+y*engineWindowX);
  int a;
  for (a=pos;a<pos+l_;a++)
    pixel[a]=color_;
}    
#endif
#endif

#ifdef X86CPU
void hline(Uint16* pixel,Sint32 x,Sint32 y,Sint32 l_,Uint16 color_,char check)
{
  //l_++;
  if (check)
  { 
    if (y<0)
      return;
    if (y>=engineWindowY) //Their is a FUCKING Bug if I write in the last line on the gp2x. Dont know why...
      return;
    if (x<0)
    {
      l_=x+l_;
      x=0;
    }
    if (x+l_>=engineWindowX)
      l_=engineWindowX-x;
    if (l_<=0)
      return;
  }
  Uint32 pos=(x+y*engineWindowX);
  if ((int)pixel+(pos<<1) & 2)
  {
    pixel[pos]=color_;
    pos++;
    l_--;
  }
  Uint32 color=color_ | (color_<<16);
  int a;
  for (a=pos>>1;a<(pos+l_>>1);a++)
    ((Uint32*)pixel)[a]=color;
  pixel[pos+l_-1]=color_;
}    
#endif

void draw_and_share_X(Uint16* pixel,Sint16 x1,Sint16 x2,Sint16 y,Uint16 color)
{
  if (x1 == x2)
    return;
  int nx = x1+x2>>1;
  if (nx == x1)
    return;
  if (nx == x2)
    return;
  if (nx>=0 && y>=0 && nx<engineWindowX && y<engineWindowY)
    pixel[nx+y*engineWindowX] = color;
  draw_and_share_X(pixel,x1,nx,y,color);
  draw_and_share_X(pixel,nx,x2,y,color);
}


void draw_and_share(Uint16* pixel,Sint16 x1_l,Sint16 x1_r,Sint16 y1,Sint16 x2_l,Sint16 x2_r,Sint16 y2,Uint16 color)
{
  if (y1 == y2)
    return;
  int ny = y1+y2>>1;
  if (ny == y1)
    return;
  if (ny == y2)
    return;
  int nx_l = x1_l+x2_l>>1;
  int nx_r = x1_r+x2_r>>1;
  
  draw_and_share_X(pixel,nx_l,nx_r,ny,color);
  /*if (nx_l < nx_r)
    hline(pixel,nx_l,ny,nx_r-nx_l+1,color,1);
  else
    hline(pixel,nx_r,ny,nx_l-nx_r+1,color,1);*/
  if (nx_l>=0 && ny>=0 && nx_l<engineWindowX && ny<engineWindowY)
    pixel[nx_l+ny*engineWindowX] = color;
  if (nx_r>=0 && ny>=0 && nx_r<engineWindowX && ny<engineWindowY)
    pixel[nx_r+ny*engineWindowX] = color;
  draw_and_share(pixel,x1_l,x1_r,y1,nx_l,nx_r,ny,color);
  draw_and_share(pixel,nx_l,nx_r,ny,x2_l,x2_r,y2,color);
}

void triangle(SDL_Surface* screen,Sint16 x1,Sint16 y1,Sint16 x2,Sint16 y2,Sint16 x3,Sint16 y3,Uint16 color)
{
  if (y1 > y2)
  {
      Sint16 temp = y1;
      y1 = y2;
      y2 = temp;
      temp = x1;
      x1 = x2;
      x2 = temp;
  }
  if (y1 > y3)
  {
      Sint16 temp = y1;
      y1 = y3;
      y3 = temp;
      temp = x1;
      x1 = x3;
      x3 = temp;
  }
  if (y2 < y3)
  {
      Sint16 temp = y2;
      y2 = y3;
      y3 = temp;
      temp = x2;
      x2 = x3;
      x3 = temp;
  }
  
  
  SDL_LockSurface(screen);
  Uint16* pixel=(Uint16*)screen->pixels;
  
  
  int div = y2-y1;
  if (div!=0)
  {
    if (div<0)
      div = -div;
    int mul = y3-y1;
    if (mul < 0)
      mul = -mul;
    int x4 = x1+(x2-x1)*mul/div;
    if (x1>=0 && y1>=0 && x1<engineWindowX && y1<engineWindowY)
      pixel[x1+y1*engineWindowX] = color;  
    if (x2>=0 && y2>=0 && x2<engineWindowX && y2<engineWindowY)
      pixel[x2+y2*engineWindowX] = color;  
    if (x3>=0 && y3>=0 && x3<engineWindowX && y3<engineWindowY)
      pixel[x3+y3*engineWindowX] = color;  
    if (x4>=0 && y3>=0 && x4<engineWindowX && y3<engineWindowY)
      pixel[x4+y3*engineWindowX] = color;  
    /*if (x4 < x3)
      hline(pixel,x4,y3,x3-x4+1,color,1);
    else
      hline(pixel,x3,y3,x4-x3+1,color,1);*/
    draw_and_share_X(pixel,x3,x4,y3,color);
    draw_and_share(pixel,x1,x1,y1,x4,x3,y3,color);
    draw_and_share(pixel,x4,x3,y3,x2,x2,y2,color);
  }

  
  SDL_UnlockSurface(screen);
  /*int mny=y1;
  int mxy=y1;
  if (y2<mny) mny=y2;
  if (y2>mxy) mxy=y2;
  if (y3<mny) mny=y3;
  if (y3>mxy) mxy=y3;

  if (mny<0)
    mny=0;
  if (mxy>=engineWindowY)
    mxy=engineWindowY-1;
  if (mny>engineWindowY-1)
    return;
  if (mxy<0)
    return;

  int mul1=x1-x3; int div1=y1-y3;
  int mul2=x2-x1; int div2=y2-y1;
  int mul3=x3-x2; int div3=y3-y2;

  SDL_LockSurface(screen);
  Uint16* pixel = (Uint16*)(screen->pixels);

  int yc;
  for (yc=mny;yc<=mxy;yc++)
  {
    int mnx=engineWindowX;
    int mxx=-1;
    if (y3>=yc || y1>=yc)
      if (y3<=yc || y1<=yc)
        if (y3!=y1)
        {
          int x=(yc-y3)*mul1 / div1 + x3;
          if (x<mnx)
            mnx=x;
          if (x>mxx)
            mxx=x;
        }
    if (y1>=yc || y2>=yc)
      if (y1<=yc || y2<=yc)
        if (y1!=y2)
        {
          int x=(yc-y1)*mul2 / div2 + x1;
          if (x<mnx)
            mnx=x;
          if (x>mxx)
            mxx=x;
        }
    if (y2>=yc || y3>=yc)
      if (y2<=yc || y3<=yc)
        if (y2!=y3)
        {
          int x=(yc-y2)*mul3 / div3 + x2;
          if (x<mnx)
            mnx=x;
          if (x>mxx)
            mxx=x;
        }
    if (mnx<0)
      mnx=0;
    if (mxx>engineWindowX-1)
      mxx=engineWindowX-1;
    if (mnx<=mxx)
      hline(pixel,mnx,yc,mxx-mnx+1,color,1);
  }
  SDL_UnlockSurface(screen);*/
  
}

void quad(SDL_Surface* screen,Sint16 x1,Sint16 y1,Sint16 x2,Sint16 y2,Sint16 x3,Sint16 y3,Sint16 x4,Sint16 y4,Uint16 color)
{
  triangle(screen,x1,y1,x2,y2,x3,y3,color);
  triangle(screen,x1,y1,x3,y3,x4,y4,color);
  /*int mny=y1;
  int mxy=y1;
  if (y2<mny) mny=y2;
  if (y2>mxy) mxy=y2;
  if (y3<mny) mny=y3;
  if (y3>mxy) mxy=y3;
  if (y4<mny) mny=y4;
  if (y4>mxy) mxy=y4;

  if (mny<0)
    mny=0;
  if (mxy>=engineWindowY)
    mxy=engineWindowY-1;
  if (mny>engineWindowY-1)
    return;
  if (mxy<0)
    return;

  int mul1=x1-x4; int div1=y1-y4;
  int mul2=x2-x1; int div2=y2-y1;
  int mul3=x3-x2; int div3=y3-y2;
  int mul4=x4-x3; int div4=y4-y3;

  SDL_LockSurface(screen);  
  Uint16* pixel = (Uint16*)(screen->pixels);
  
  int yc;
  for (yc=mny;yc<=mxy;yc++)
  {
    int mnx=engineWindowX;
    int mxx=-1;
    if (y4>=yc || y1>=yc)
      if (y4<=yc || y1<=yc)
        if (y4!=y1)
        {
          int x= (yc-y4)*mul1 / div1 + x4;;
          if (x<mnx)
            mnx=x;
          if (x>mxx)
            mxx=x;
        }
    if (y1>=yc || y2>=yc)
      if (y1<=yc || y2<=yc)
        if (y1!=y2)
        {
          int x=(yc-y1)*mul2 / div2 + x1;
          if (x<mnx)
            mnx=x;
          if (x>mxx)
            mxx=x;
        }
    if (y2>=yc || y3>=yc)
      if (y2<=yc || y3<=yc)
        if (y2!=y3)
        {
          int x=(yc-y2)*mul3 / div3 + x2;
          if (x<mnx)
            mnx=x;
          if (x>mxx)
            mxx=x;
        }
    if (y3>=yc || y4>=yc)
      if (y3<=yc || y4<=yc)
        if (y3!=y4)
        {
          int x=(yc-y3)*mul4 / div4 + x3;
          if (x<mnx)
            mnx=x;
          if (x>mxx)
            mxx=x;
        }
    if (mnx<0)
      mnx=0;
    if (mxx>engineWindowX-1)
      mxx=engineWindowX-1;
    if (mnx<=mxx)
      hline(pixel,mnx,yc,mxx-mnx+1,color,1);
  }
  SDL_UnlockSurface(screen);*/
}

void clearScreen(SDL_Surface* screen,Uint16 color)
{
  SDL_LockSurface(screen);
  Uint16* pixel = (Uint16*)(screen->pixels);
  hline(pixel,0,0,engineWindowX-1,0,0);
  hline(pixel,0,1,engineWindowX*(engineWindowY-1),color,0); //the last scanlines makes bugs -_-
  hline(pixel,0,engineWindowY-1,engineWindowX-1,0,0);
  SDL_UnlockSurface(screen);
}

void ellipse(SDL_Surface* screen,Sint16 mx,Sint16 my,Sint16 rx,Sint16 ry,Uint16 color)
{
  Sint16 y;
  //rx++;
  //ry++;
  Uint16* pixel = (Uint16*)(screen->pixels);
  for (y=my-ry;y<=my+ry;y++)
  {
    Sint16 dividend = (ry*ry);
    Sint16 root;
    if (dividend==0)
      root = 0;
    else
      root = fpsqrt((ry*ry*rx*rx-(y-my)*(y-my)*rx*rx)/dividend)>>HALF_ACCURACY;
    /*if (root==0)
      continue;
    if (y==my)
      root--;*/
    hline(pixel,mx-root,y,root*2+1,color,1);
  }  
}
