
#include "board.h"

#include <QDebug>
#include <QPainter>
#include "Animation.h"

Board::Board( QSize aBoardSize,QObject* aParent )
    : QObject(aParent), mBoardSize( aBoardSize ),mDrawCellNo( false )
{
    mCellCount = aBoardSize.width()* aBoardSize.height();
}

Board::~Board()
{
    foreach( int index,mSmilys.keys() ) {
        delete mSmilys[index];
    }
    mSmilys.clear();
}

void Board::draw(  QPainter& aPainter)
{
    foreach( Smily* smily, mDrawList ){
        smily->draw( aPainter );
    }

    //draw grid
    aPainter.setPen(Qt::gray);
    for( int i = 1 ; i < mBoardSize.height() ; ++i ) {
        aPainter.drawLine(QPoint(0,i*SMILY_SIZE), QPoint(mBoardSize.width()*SMILY_SIZE,i*SMILY_SIZE));
    }

    for( int i = 1 ; i < mBoardSize.width() ; ++i ) {
        aPainter.drawLine(QPoint(i*SMILY_SIZE,0), QPoint(i*SMILY_SIZE,mBoardSize.height()*SMILY_SIZE));
    }

    if( mDrawCellNo ) {
        //draw cell number
        aPainter.setPen(Qt::darkMagenta);
        QFont font = aPainter.font();
        font.setPointSize(6);
        aPainter.setFont(font);
        for( int i = 0, y = 25 ; i < mBoardSize.height() ; ++i ) {
            for( int j = 0 ,x = 10; j < mBoardSize.width() ; ++j ) {
                QString str;
                str.setNum( boradIndexToArrayIndex( i,j ) );
                aPainter.drawText(QPoint(x,y), str);
                x += SMILY_SIZE;
            }
            y += SMILY_SIZE;
        }
    }
}

void Board::append( Smily* aSmily )
{    
    qDebug() << "Board::append()";

    int positionOnBord = boradIndexToArrayIndex( aSmily->boardPos().row(),aSmily->boardPos().column() );
    Q_ASSERT( mSmilys.value(positionOnBord,0) == 0 );
    mSmilys[ positionOnBord ] = aSmily;    
    mDrawList << aSmily;
}

void Board::checkForMatch()
{
    qDebug() << "Board::checkForMatch()";

    for( int i = 0 ; i < mCellCount ; ++i ) {
        if( mSmilys.value(i,0) != 0 ) {
            if ( checkForMatchingRow( i ) ) {
                continue;
            }

            if ( checkForMatchingColumn( i ) ) {
                continue;
            }

            checkForMatchingBlock( i );
        }
    }
    qDebug() << "Smily Count :: "<< mSmilys.count();
}

bool Board::isColliding( Smily& aSmily )
{
    //check vertical collision
    BoardPos boardPos = aSmily.boardPos();
    int positionToCheck =  boradIndexToArrayIndex( boardPos.row() + 1 , boardPos.column() ); //column  + ( ( row + 1) * mBoardSize.width() );

    return ( mSmilys.value(positionToCheck,0) != 0 ) || ( boardPos.row() >= size().height() -1 );
}

bool Board::canSlide( Smily& aSmily, int aDirection )
{
    if( (aDirection < 0 && aSmily.boardPos().column() <= 0) ||
         aDirection > 0 && aSmily.boardPos().column() >= mBoardSize.width() - 1 ) {
        return false;
    }

    BoardPos boardPos = aSmily.boardPos();
    int positionToCheck =  boradIndexToArrayIndex( boardPos.row() , boardPos.column() + aDirection);

    return ( mSmilys.value(positionToCheck,0) == 0 );
}

bool Board::checkForMatchingRow( int aIndexToCheck )
{
    QList<Animable*> smilys;
    smilys << mSmilys.value(aIndexToCheck);

    QColor colorToMatchWith = mSmilys.value(aIndexToCheck)->color();
    BoardPos boardPos = arrayIndexToBoardIndex( aIndexToCheck);
    for( int i = boardPos.column() + 1 ; i < mBoardSize.width() ; ++i ) {
        Smily* smily = smilyFromBoardPos( boardPos.row(), i );
        if( smily != 0 && colorToMatchWith == smily->color() ) {
            smilys << smily;            
        }
        else {
            break;
        }
    }

    if( smilys.count() > 2 ) {
        qDebug() << "Board::checkForMatchingRow() matchFound:" << aIndexToCheck;
        startAnimation( smilys );
        return true;
    }
    return false;
}

bool Board::checkForMatchingColumn( int aIndexToCheck )
{
    QList<Animable*> smilys;
    smilys << mSmilys.value(aIndexToCheck);

    QColor colorToMatchWith = mSmilys.value(aIndexToCheck)->color();
    BoardPos boardPos = arrayIndexToBoardIndex( aIndexToCheck);
    for( int i = boardPos.row() + 1 ; i < mBoardSize.height() ; ++i ) {        
        Smily* smily = smilyFromBoardPos( i, boardPos.column() );
        if( smily != 0  && colorToMatchWith == smily->color() ) {
            smilys << smily;
        }
        else {
            break;
        }
    }

    if( smilys.count() > 2 ) {
        qDebug() << "Board::checkForMatchingColumn() matchFound:" << aIndexToCheck;        
        startAnimation( smilys );
        return true;
    }
    return false;
}

bool Board::checkForMatchingBlock( int aIndexToCheck )
{
    QList<Animable*> smilys;
    QColor colorToMatchWith = mSmilys.value(aIndexToCheck)->color();
    BoardPos boardPos = arrayIndexToBoardIndex( aIndexToCheck);
    for( int i = boardPos.row() ; i < boardPos.row() + 2 ; ++i ) {
        for( int j = boardPos.column() ; j < boardPos.column() + 2 ; ++j ) {
            Smily* smily = smilyFromBoardPos( i, j );
            if( smily != 0  && colorToMatchWith == smily->color() ) {
                smilys << smily;
            }
            else {
                break;
            }
        }
    }

    if( smilys.count() == 4 ) {
        qDebug() << "Board::checkForMatchingColumn() matchFound:" << aIndexToCheck;
        startAnimation( smilys );
        return true;
    }
    return false;
}


void Board::collepseIfRequired()
{
    bool collepsed = false;
    qDebug() << "############# collepseIfRequired ###################";
    for( int row = mBoardSize.height() -1 ; row > 0 ; --row ) {
        for( int column = 0 ; column < mBoardSize.width() ; ++column )
        {
            int boardIndex = boradIndexToArrayIndex( row, column);
            int upperBoardIndex = boradIndexToArrayIndex( row - 1, column);

            if( (mSmilys.value(boardIndex,0) == 0 ) &&
              ( mSmilys.value(upperBoardIndex,0) != 0 ) )  {
                qDebug() << "############# FALL ###################";
                qDebug() << "boardIndex=" << boardIndex;
                qDebug() << "upperBoardIndex=" << upperBoardIndex;
                collepsed = true;

                Smily* smily = mSmilys.value(upperBoardIndex);
                smily->fall();
                mSmilys[boardIndex] = smily;
                mSmilys.remove(upperBoardIndex);
            }
        }
    }

    if( collepsed ) {
        collepseIfRequired();
    }
}


void Board::startAnimation( const QList<Animable*>& aList )
{
    qDebug() << "Board::startAnimation()";
    Animation* animation = new Animation(this);
    animation->setAnimableObject( aList );
    animation->setTimeValue( 200 );
    animation->start();
    QObject::connect( animation,SIGNAL(animationComplete(Animation *)),this,SLOT(animationComplete(Animation *)));
    mAnimationList.append(animation);

    foreach( Animable* animable, aList ){
        Smily* smily = dynamic_cast<Smily*>( animable );
        int positionOnBoard = boradIndexToArrayIndex( smily->boardPos().row(),smily->boardPos().column() );
        mSmilys.remove( positionOnBoard);
    }
}

void Board::animationComplete( Animation *aAnimation )
{
    qDebug() << "Board::animationComplete()";
    int points = 0;
    foreach( Animable* animable, aAnimation->targetObject() ) {
        Smily* smily = dynamic_cast<Smily*>( animable );
        BoardPos pos = smily->boardPos();
        int positionOnBoard = boradIndexToArrayIndex( pos.row(), pos.column() );
        mSmilys.remove( positionOnBoard );
        mDrawList.removeOne( smily );
        points+=10;
    }    
    emit pointsEarned( points );    
    mAnimationList.removeOne( aAnimation );
    collepseIfRequired();
    aAnimation->deleteLater();    
    checkForMatch();
}

bool Board::isTouchingTop()
{
    qDebug() << "Board::isTouchingTop()";

    for( int i = 0 ; i < this->size().width() ;++i ) {
        int arrayIndex = boradIndexToArrayIndex(0,i);
        if ( mSmilys.value( arrayIndex,0) != 0 ) {
            qDebug() << "################# game over ###############";
            return true;
        }
    }
    return false;
}

