/*
    Copyright (C) <2010>  <Markus Scharnowski markus.scharnowski@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <QPushButton>
#include <QTextBrowser>
#include <QHBoxLayout>
#include <QFileDialog>
#include <QMessageBox>

#include <iostream>
#include <fstream>

#include "showfulllistdialog.hpp"

ShowFullListDialog::ShowFullListDialog(QWidget *parent, QString text) :
    QDialog(parent)
{
  QPushButton *doneButton = new QPushButton(tr("&Done"));
  QPushButton *saveButton = new QPushButton(tr("&Save"));
  QPushButton *saveEditedButton = new QPushButton(tr("S&ave edited version"));
  textEdit = new QTextBrowser;
  textEdit->setReadOnly(false);
  textEdit->setText(text);
  initialString = text;

  QVBoxLayout *layout = new QVBoxLayout;
  layout->addWidget(doneButton);
  layout->addWidget(saveButton);
  layout->addWidget(saveEditedButton);
  layout->addStretch();

  QHBoxLayout *mainLayout = new QHBoxLayout;
  mainLayout->addLayout(layout);
  mainLayout->addWidget(textEdit);

  connect(doneButton, SIGNAL(clicked()), this, SLOT(deleteLater()));
  connect(saveButton, SIGNAL(clicked()), this, SLOT(save()));
  connect(saveEditedButton, SIGNAL(clicked()), this, SLOT(saveEdited()));

  setLayout(mainLayout);
  setWindowTitle(tr("History"));
  setBaseSize(700,400);
  setMinimumWidth(600);
  setMinimumHeight(400);
  hide();
}

ShowFullListDialog::~ShowFullListDialog()
{
}

int ShowFullListDialog::saveToFile(QString string)
{
  QString fileName = QFileDialog::getSaveFileName(0,
                                                  tr("Save to"), "",
                                                  tr("Push-It textfile (*.pushit);;All Files (*.*)"));
  if (fileName.isEmpty())
  {
    return EXIT_FAILURE;
  }
  else
  {
    std::ofstream myfile;
    myfile.open(fileName.toStdString().c_str());
    if (!myfile.is_open())
    {
      QMessageBox::information(0, tr("Unable to open file"),
                               tr("Unable to open file"));
      return EXIT_FAILURE;
    }
    myfile << string.toStdString();
    myfile.close();
  }
  return EXIT_SUCCESS;
}

void ShowFullListDialog::save()
{
  saveToFile(initialString);
}

void ShowFullListDialog::saveEdited()
{
  saveToFile(textEdit->toPlainText());
}
