/*
    Copyright (C) <2010>  <Markus Scharnowski markus.scharnowski@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <QPushButton>
#include <QTextEdit>
#include <QHBoxLayout>
#include <QLabel>

#include "aboutdialog.hpp"

AboutDialog::AboutDialog(QString name, QString customUrl, QWidget *parent) :
    QDialog(parent)
{
  browserGeneral = new QTextBrowser;
  browserGeneral->setOpenExternalLinks(true);
  browserDonate = new QTextBrowser;
  browserDonate->setOpenExternalLinks(true);
  browserWebsite = new QTextBrowser;
  browserWebsite->setOpenExternalLinks(true);
  browserFeedback = new QTextBrowser;
  browserFeedback->setOpenExternalLinks(true);

  tabs = new QTabWidget;
  tabs->insertTab(1,browserGeneral,tr("&General"));
  tabs->insertTab(2,browserDonate,tr("&Donate"));
  tabs->insertTab(3,browserWebsite,tr("&Website"));
  tabs->insertTab(4,browserFeedback,tr("&Feedback"));

  QHBoxLayout *layout = new QHBoxLayout();
  layout->addWidget(tabs);

  setLayout(layout);
  setBaseSize(700,400);
  setMinimumWidth(700);
//  setMinimumHeight(400);

  setProgramName(name);
  setProgramUrl(customUrl);
  setGeneralHtmlText();
  setWebsiteHtmlText();
  setDonateHtmlText();
  setFeedbackHtmlText();
  hide();
}

AboutDialog::~AboutDialog()
{
}

int AboutDialog::setProgramName(QString name)
{
  programName = name;

  QString wTitle = "About " + name;
  setWindowTitle(tr(wTitle.toStdString().c_str()));

  refreshDefaultTexts();
  return EXIT_SUCCESS;
}

int AboutDialog::setProgramUrl(QString url)
{
  programUrl = url;
  refreshDefaultTexts();
  return EXIT_SUCCESS;
}

int AboutDialog::setGeneralHtmlText(QString htmlText)
{
  if("" == htmlText)
  {
    textGeneral =
        "<p>" + programName + "</p>"
        "<p>Idea and programming: <a href=\"mailto:markus.scharnowski@gmail.com?subject=Thank you for " + programName +
        "&body=Hello Markus,\">Markus Scharnowski</a></p>"
        ;
  }
  else
  {
    textGeneral = htmlText;
  }

  browserGeneral->setText(tr(textGeneral.toStdString().c_str()));
  return EXIT_SUCCESS;
}

int AboutDialog::setDonateHtmlText(QString htmlText)
{
  if("" == htmlText)
  {
    textDonate =
        "You like what you have in your hands? You use it on regular basis? Support the devolpment by making a donation."
        "<p>Donate through "
        "<a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=TPX9PV29D4L9Y\">paypal</a></p>"
        "<p>Visit the projects <a href=\"https://sites.google.com/site/markusscharnowski/donate\">donation website</a></p>"
        ;
  }
  else
  {
    textDonate = htmlText;
  }

  browserDonate->setText(tr(textDonate.toStdString().c_str()));
  return EXIT_SUCCESS;
}

int AboutDialog::setWebsiteHtmlText(QString htmlText)
{
  if("" == htmlText)
  {
    textWebsite =
        "<p>Visit</p>"
        "<p>"
        "<a href=\""+ programUrl + "\">" + programUrl + "</a><br>"
        "<a href=\"http://sites.google.com/site/markusscharnowski\">http://sites.google.com/site/markusscharnowski</a>"
        "</p>"
        ;
  }
  else
  {
    textWebsite = htmlText;
  }

  browserWebsite->setText(tr(textWebsite.toStdString().c_str()));
  return EXIT_SUCCESS;
}

int AboutDialog::setFeedbackHtmlText(QString htmlText)
{
  if("" == htmlText)
  {
    textFeedback =
        "<p>Do you have ideas for improving the program? You want a specific functionality? "
        ""
        "You have found a bug?</p>"
        "<p>Email <a href=\"mailto:markus.scharnowski@gmail.com?subject=SW Feedback " + programName +
        " &body=Hello Markus,\">Feedback</a></p>"
        ;
  }
  else
  {
    textFeedback = htmlText;
  }

  browserFeedback->setText(tr(textFeedback.toStdString().c_str()));
  return EXIT_SUCCESS;
}

int AboutDialog::refreshDefaultTexts()
{
  setGeneralHtmlText("");
  setWebsiteHtmlText("");
  setDonateHtmlText("");
  setFeedbackHtmlText("");
  return EXIT_SUCCESS;
}
