#ifndef __SDL_H__
#define __SDL_H__

#include <math.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <stdarg.h>
#include <unistd.h>
#include <SDL.h>
#include <SDL_syswm.h>

#include "../psxTypes.h"

#include "gui.h"

enum  { MAEMOKEY_UP=(1<<4),     MAEMOKEY_LEFT=(1<<7),    MAEMOKEY_DOWN=(1<<6), MAEMOKEY_RIGHT=(1<<5),
        MAEMOKEY_L1=(1<<10),    MAEMOKEY_R1=(1<<11),     MAEMOKEY_L2=(1<<8),   MAEMOKEY_R2=(1<<9),
        MAEMOKEY_X =(1<<15),    MAEMOKEY_O =(1<<13),     MAEMOKEY_T =(1<<12),  MAEMOKEY_S =(1<<15),
        MAEMOKEY_START=(1<<18), MAEMOKEY_SELECT=(1<<19), MAEMOKEY_QUIT=(1<<27) };

typedef struct gp2x_font        { int x,y,w,wmask,h,fg,bg,solid; unsigned char *data; } gp2x_font;

#define gp2x_video_RGB_color16(R,G,B) ((unsigned short)(((((R)&0xF8)<<8)|(((G)&0xFC)<<3)|(((B)&0xF8)>>3))))

extern void		*gp2x_sdlwrapper_screen_pixels;
#define gp2x_screen16	((unsigned short *)gp2x_sdlwrapper_screen_pixels)

void gp2x_video_flip();
#define gp2x_video_flip_single() gp2x_video_flip(); //SDL_Flip(sdlscreen);

void gp2x_printf(gp2x_font *f, int x, int y, const char *format, ...);

extern void gp2x_change_res(int w, int h);
extern void gp2x_video_RGB_clearscreen16(void);

#define gp2x_timer_delay(T) usleep(T * 1000)
extern u64 gp2x_timer_read(void);
#define gp2x_timer_raw() gp2x_timer_read()
#define gp2x_timer_raw_second() (1000)
#define gp2x_timer_raw_to_ticks(t) (t)

unsigned long gp2x_joystick_read(void);
void gp2x_init(int ticks_per_second, int bpp, int rate, int bits, int stereo, int hz, int solid_font);
void gp2x_deinit(void);

#endif // __SDL_H__
