/*
 *  presence notifier control panel plugin
 *  Copyright (C) 2011 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <hildon/hildon.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <string.h>
#include <locale.h>
#include <gconf/gconf-client.h>

#define GC_ROOT "/apps/maemo/presence-notifier"
#define NOTIFIER_DISABLED_GCONF_PATH GC_ROOT "/disabled"
#define NOTIFIER_NOTIFY_ONLINE_ONLY_GCONF_PATH GC_ROOT "/online_only"
#define NOTIFIER_NOTIFY_STATUS_MESSAGE_GCONF_PATH GC_ROOT "/status_message"
#define NOTIFIER_AUTO_CLOSE_TIME_GCONF_PATH GC_ROOT "/notification_timeout"
#define NOTIFIER_AUTO_CLOSE_NOTIFICATION_GCONF_PATH GC_ROOT "/auto_notification_close"


static void
_enable_disable_seconds_box(HildonCheckButton *button,
			    gpointer user_data)
{
  GtkWidget* box = GTK_WIDGET(user_data);
  gtk_widget_set_sensitive(box, hildon_check_button_get_active(button));
			   
/*
  GConfClient* client = gconf_client_get_default();
  if(!GCONF_IS_CLIENT(client))
    return;
  gconf_client_set_bool(client, NOTIFIER_DISABLED_GCONF_PATH, !hildon_check_button_get_active(button), NULL);
  g_object_unref(client);
*/
}

osso_return_t execute(osso_context_t* osso, gpointer user_data, gboolean user_activated)
{
  GtkWidget* dialog = gtk_dialog_new_with_buttons("Settings",
						  GTK_WINDOW(user_data),
						  GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR,
						  dgettext("hildon-libs", "wdgt_bd_save"), GTK_RESPONSE_ACCEPT,
						  NULL);

  gtk_window_set_default_size(GTK_WINDOW(dialog), -1, 350);

  GtkWidget* active_check_button = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_button_set_label(GTK_BUTTON(active_check_button), "Enable Notifier");

  GtkWidget* label = gtk_label_new("Notification when contacts:");
  GtkWidget* content = gtk_vbox_new(FALSE, 0);

  GtkWidget* online_only_state_change = hildon_gtk_radio_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
  gtk_button_set_label(GTK_BUTTON(online_only_state_change), "go online");
  gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(online_only_state_change), FALSE);
  GtkWidget* all_status_change = hildon_gtk_radio_button_new_from_widget(HILDON_SIZE_FINGER_HEIGHT, GTK_RADIO_BUTTON(online_only_state_change));
  gtk_button_set_label(GTK_BUTTON(all_status_change), "change status");
  gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(all_status_change), FALSE);

  GtkWidget* status_message_change = hildon_gtk_toggle_button_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_button_set_label(GTK_BUTTON(status_message_change), "change status message");
  GtkWidget* status_message_change_box = gtk_vbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(status_message_change_box), status_message_change, TRUE, FALSE, 0);

  GtkWidget* status_box = gtk_hbox_new(FALSE, 0);
  GtkWidget* status_change_box = gtk_hbox_new(FALSE, 0);

  GtkWidget* auto_hide_notification = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_button_set_label(GTK_BUTTON(auto_hide_notification), "Autoclose Notification");


  GtkWidget* seconds_input = hildon_entry_new(HILDON_SIZE_FINGER_HEIGHT);
  hildon_gtk_entry_set_input_mode(GTK_ENTRY(seconds_input), HILDON_GTK_INPUT_MODE_NUMERIC);
  GtkWidget* seconds_label = gtk_label_new("seconds");
  GtkWidget* seconds_box = gtk_hbox_new(TRUE, 0);


  gtk_box_pack_start(GTK_BOX(seconds_box), seconds_input, TRUE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(seconds_box), seconds_label, TRUE, FALSE, 0);

  gtk_box_pack_start(GTK_BOX(status_change_box), online_only_state_change, TRUE, FALSE, 0);
  gtk_box_pack_end(GTK_BOX(status_change_box), all_status_change, TRUE, FALSE, 0);

  gtk_box_pack_start(GTK_BOX(status_box), status_change_box, TRUE, FALSE, 0);
  gtk_box_pack_end(GTK_BOX(status_box), status_message_change_box, TRUE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(content), active_check_button, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(content), label, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(content), status_box, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(content), auto_hide_notification, TRUE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(content), seconds_box, TRUE, FALSE, 0);

  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), content);

  GConfClient* client = gconf_client_get_default();
  hildon_check_button_set_active(HILDON_CHECK_BUTTON(active_check_button), 
				 !gconf_client_get_bool(client, NOTIFIER_DISABLED_GCONF_PATH, NULL));
  if(gconf_client_get_bool(client, NOTIFIER_NOTIFY_ONLINE_ONLY_GCONF_PATH, NULL))
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(online_only_state_change),
      TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(all_status_change),
      TRUE);
  
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(status_message_change), 
			       gconf_client_get_bool(client, NOTIFIER_NOTIFY_STATUS_MESSAGE_GCONF_PATH, NULL));
  
  hildon_check_button_set_active(HILDON_CHECK_BUTTON(auto_hide_notification),
				 gconf_client_get_bool(client, NOTIFIER_AUTO_CLOSE_NOTIFICATION_GCONF_PATH, NULL));
  
  
  int time_out = gconf_client_get_int(client, NOTIFIER_AUTO_CLOSE_TIME_GCONF_PATH, NULL);
  if(!hildon_check_button_get_active(HILDON_CHECK_BUTTON(auto_hide_notification)) &&
     time_out == 0)
  {
    hildon_check_button_set_active(HILDON_CHECK_BUTTON(auto_hide_notification), TRUE);
    time_out = 6;
  }

  if(!hildon_check_button_get_active(HILDON_CHECK_BUTTON(auto_hide_notification)))
    gtk_widget_set_sensitive(GTK_WIDGET(seconds_box), FALSE);

  gchar* time_out_str = g_strdup_printf("%d", time_out);
  hildon_entry_set_text(HILDON_ENTRY(seconds_input), time_out_str);
  g_free(time_out_str);

  g_signal_connect(auto_hide_notification, "toggled", G_CALLBACK(_enable_disable_seconds_box), seconds_box);
  
  g_object_unref(client);
  gtk_widget_show_all(dialog);
  
  guint response = gtk_dialog_run(GTK_DIALOG(dialog));
  if(response == GTK_RESPONSE_ACCEPT)
  {
    gboolean disable = !hildon_check_button_get_active(HILDON_CHECK_BUTTON(active_check_button));
    gboolean online_only = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(online_only_state_change));
    gboolean message_change = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(status_message_change));
    gboolean auto_hide = hildon_check_button_get_active(HILDON_CHECK_BUTTON(auto_hide_notification));
    int time_out = atoi(hildon_entry_get_text(HILDON_ENTRY(seconds_input)));
    GConfClient* client = gconf_client_get_default();
    gconf_client_set_bool(client, NOTIFIER_DISABLED_GCONF_PATH, disable, NULL);
    gconf_client_set_bool(client, NOTIFIER_NOTIFY_ONLINE_ONLY_GCONF_PATH, online_only, NULL);
    gconf_client_set_bool(client, NOTIFIER_NOTIFY_STATUS_MESSAGE_GCONF_PATH, message_change, NULL);
    gconf_client_set_bool(client, NOTIFIER_AUTO_CLOSE_NOTIFICATION_GCONF_PATH, auto_hide, NULL);
    if(auto_hide)
      gconf_client_set_int(client, NOTIFIER_AUTO_CLOSE_TIME_GCONF_PATH, time_out, NULL);
    else
      gconf_client_set_int(client, NOTIFIER_AUTO_CLOSE_TIME_GCONF_PATH, 0, NULL);
    g_object_unref(client);
  }
  gtk_widget_destroy(dialog);
  return OSSO_OK;
}

osso_return_t save_state(osso_context_t* osso, gpointer user_data)
{
  return OSSO_OK;
}


