#ifndef _PRIVATE_H_
#define _PRIVATE_H_

#include <SDL.h>
#include <PDL.h>

struct size {
	unsigned int w, h;
};

struct point {
	unsigned int x, y;
};

struct box {
	unsigned int x, y;
	unsigned int w, h;
};

struct pointf {
	float x, y;
};

#pragma GCC visibility push(hidden)
extern SDL_Surface *screen;
extern struct size v_size;
extern PDL_Orientation v_orient;
extern struct pointf s_scale;
extern PDL_Orientation s_rotate;
extern struct size r_size;

void SDLPRE_RefreshScale();

PDL_Err PDL_EnsureInit();
void PDL_NotifyFocus(SDL_bool focus);

void X11_Init();
void X11_SetDoNotDisturb(SDL_bool set);
#pragma GCC visibility pop

#endif
