#include "PowerMenuEntryCreator.h"
#include <QDebug>

QXmlStreamWriter& PowerMenuEntryCreator::writeLaunchAppCallback(QXmlStreamWriter& w)
{

    /*QDomElement el = doc.createElement("callback");
    el.setAttribute("service", "com.nokia.HildonDesktop.AppMgr");
    el.setAttribute("path", "/com/nokia/HildonDesktop/AppMgr");
    el.setAttribute("interface", "com.nokia.HildonDesktop.AppMgr");
    el.setAttribute("method", "LaunchApplication");
    el.setAttribute("bus", "session");
    el.setAttribute("autostart", true);
    return el;*/


    QXmlStreamAttributes atr;
    atr.append("service", "com.nokia.HildonDesktop.AppMgr");
    atr.append("path", "/com/nokia/HildonDesktop/AppMgr");
    atr.append("interface", "com.nokia.HildonDesktop.AppMgr");
    atr.append("method", "LaunchApplication");
    atr.append("bus", "session");
    atr.append("autostart", "true");

    w.writeStartElement("callback");
    w.writeAttributes(atr);

    w.writeStartElement("argument");
    w.writeAttribute("type", "string");
    w.writeCharacters(stripFilename(argument));

    w.writeEndElement(); // argument

    w.writeEndElement(); // callback

    return w;
}

QXmlStreamWriter& PowerMenuEntryCreator::writeXTermCommandCallback(QXmlStreamWriter &w)
{

    QXmlStreamAttributes atr;
    atr.append("service", "com.nokia.xterm");
    atr.append("path", "/com/nokia/xterm");
    atr.append("interface", "com.nokia.xterm");
    atr.append("method", "run_command");
    atr.append("bus", "session");
    atr.append("autostart", "true");

    w.writeStartElement("callback");
    w.writeAttributes(atr);

    w.writeStartElement("argument");
    w.writeAttribute("type", "string");
    w.writeCharacters(argument);

    w.writeEndElement(); // argument

    w.writeEndElement(); // callback

    return w;


}

bool PowerMenuEntryCreator::createEntry()
{
    QFile file(entryFileName());
    file.open(QFile::WriteOnly | QFile::Truncate);
    qDebug() << "Saving entry to " << entryFileName();
    QXmlStreamWriter writer(&file);
    writer.setAutoFormatting(true);
    writer.setCodec("UTF-8");

    //writer.writeStartDocument();

    writer.writeStartElement("powerkeymenu");
    writer.writeAttribute("path", "/");

    writer.writeStartElement("menuitem");
    writer.writeAttribute("priority", QString::number(priority));
    writer.writeAttribute("name", appName);
    writer.writeAttribute("powedit", "true");

    if (getHaveIcon() == true)
    {
        writer.writeTextElement("icon", iconUrl);
    }

    switch (entry)
    {
    case LaunchApp: writeLaunchAppCallback(writer);
    case XTermCommand: writeXTermCommandCallback(writer);
    }


    writer.writeEndElement(); // menuitem

    writer.writeEndElement(); // powerkeymenu

    file.close();
    if (file.error() != QFile::NoError) return false;
    else return true;
}

QString PowerMenuEntryCreator::entryFileName() const
{
    return ("/etc/systemui/" + appName.trimmed().toLatin1().replace(' ', '_') + ".xml");
}
