// -*- coding: utf-8; -*-
// (c) Copyright 2010, Nick Slobodsky (Николай Слободской)
// This file is part of PlansPlant.
//
// PlansPlant is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// PlansPlant is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PlansPlant.  If not, see <http://www.gnu.org/licenses/>.
//
#include <QApplication>
#include <QTranslator>
#include <QLibraryInfo>
#include <QLocale>
#include <QDebug>
#include "plansplant/widgets.hpp"

int main( int argc, char* argv[] )
{
  QApplication App( argc, argv );
  QApplication::setOrganizationName( "Nick Slobodsky" );
  QApplication::setOrganizationDomain( "slobodsky.ru" );
  QApplication::setApplicationName( "PlansPlant" );
  QApplication::setApplicationVersion( "0.0.1" );
  QTranslator QtTrans( &App );
  if( QtTrans.load( "qt_ru", QLibraryInfo::location( QLibraryInfo::TranslationsPath ) ) ) App.installTranslator( &QtTrans );
  qDebug() << "Load translator. Locale:" << QLocale().name();
  QTranslator Trans( &App ); //! \todo Make it really international and external (since we have installers for all platforms and don't have to distribute bare binaries).
  if( Trans.load( ":/lang/libplansplant-ru.qm" ) ) App.installTranslator( &Trans );
  else qDebug() << "Library translator not found.";

  QString FileName;
  if( argc > 1 ) FileName = QString::fromUtf8( argv[ 1 ] );
  PlansPlant::MainWindow* W = new PlansPlant::MainWindow();
  if( !FileName.isEmpty() ) W->open_file( FileName );
  else W->new_file();
  W->show();
  return App.exec();
} // main( int, char*[] )
