#include "acprotocol.h"

#include "pirrx51hardware.h"

#include "pirexception.h"

// Some global communications stuff:
#include <QMutex>
extern bool commandInFlight;
extern QMutex commandIFMutex;

// Due to the maintenance of state information in the remote control,
// these air conditioner protocols are quite a headache.  I'm starting with
// the Samsung AC protocol; looks to be a pulse train containing 56(?) bits
// of information.  I'll try to pin this down.
//
// A "zero" is encoded with a 500 usec pulse, 500 usec space.
// A "one" is encoded with a 500 usec pulse, 1500 usec space.
// The header is a 3000 usec pulse, 9000 usec space.
// The carrier frequency is 38 kHz.

ACProtocol::ACProtocol(
  QObject *guiObject,
  unsigned int index)
  : SpaceProtocol(
      guiObject, index,
      500, 500,
      500, 1500,
      3000, 9000,
      unknown,
      unknown, unknown)
{
}


void ACProtocol::startSendingCommand(
  unsigned int threadableID,
  PIRKeyName command)
{
}
