#include "philips.h"
#include "rc5protocol.h"

PhilipsTV1::PhilipsTV1(
  QObject *guiObject,
  unsigned int index)
  : PIRKeysetMetaData(
      "TV Keyset 1",
      Philips_Make,
      index)
{
  RC5Protocol *rp = new RC5Protocol(
    guiObject,
    index,
    900, 900,
    900,
    113000, true);

  threadableProtocol = rp;

  rp->setMinimumRepetitions(1);

  rp->setToggleBit(2);

  addKey("ON/OFF", Power_Key, 0x100C, 13);
  addKey("1", One_Key, 0x1001, 13);
  addKey("2", Two_Key, 0x1002, 13);
  addKey("3", Three_Key, 0x1003, 13);
  addKey("4", Four_Key, 0x1004, 13);
  addKey("5", Five_Key, 0x1005, 13);
  addKey("6", Six_Key, 0x1006, 13);
  addKey("7", Seven_Key, 0x1007, 13);
  addKey("8", Eight_Key, 0x1008, 13);
  addKey("9", Nine_Key, 0x1009, 13);
  addKey("0", Zero_Key, 0x1000, 13);
  addKey("VOL+", VolumeUp_Key, 0x1010, 13);
  addKey("VOL-", VolumeDown_Key, 0x1011, 13);
  addKey("MUTE", Mute_Key, 0x100D, 13);
  addKey("P+", ChannelUp_Key, 0x1020, 13);
  addKey("P-", ChannelDown_Key, 0x1021, 13);
  addKey("UP", Up_Key, 0x0010, 13);
  addKey("DOWN", Down_Key, 0x0011, 13);
  addKey("LEFT", Left_Key, 0x0015, 13);
  addKey("RIGHT", Right_Key, 0x0016, 13);
  addKey("AV", Unmapped_Key, 0x1038, 13); // "EXT"
  addKey("TIMER", Sleep_Key, 0x1026, 13);
  addKey("TELETEXT", Unmapped_Key, 0x0017, 13);
  addKey("I/II", Language_Key, 0x1023, 13); // "TEXT_REVEAL"
  addKey("RED", Red_Key, 0x00C8, 13);
  addKey("GREEN", Green_Key, 0x00FB, 13);
  addKey("YELLOW", Yellow_Key, 0x00F1, 13);
  addKey("BLUE", Blue_Key, 0x10F9, 13);
  addKey("CENTER", Unmapped_Key, 0x1029, 13); // "TEXT_STOP_SEQUENCE"
  addKey("MY_AUDIO", Unmapped_Key, 0x10D2, 13);
  addKey("EXPAND", Unmapped_Key, 0x1024, 13);
  addKey("MENU", Menu_Key, 0x0012, 13);
  addKey("INFO", Info_Key, 0x100F, 13);
  addKey("TEXT_TV", Unmapped_Key, 0x103C, 13);
  addKey("SURF", Unmapped_Key, 0x1022, 13);
  addKey("TEXT_CLOCK", Unmapped_Key, 0x102A, 13);
  addKey("TEXT_ENLARGE", Unmapped_Key, 0x102B, 13);
  addKey("PICTURE_SETTINGS", PictureMode_Key, 0x002B, 13);
  addKey("SOUND_SETTINGS", SoundMode_Key, 0x002C, 13);
  addKey("GAME", Unmapped_Key, 0x002E, 13);
}


PhilipsTV1a::PhilipsTV1a(
  QObject *guiObject,
  unsigned int index)
  : PhilipsTV1(guiObject, index)
{
  setKeysetName("TV Keyset 1a");

  addKey("TIMER", Sleep_Key, 0x002D, 13);
}
