# Add more folders to ship with the application, here
folder_01.source = qml/pgz-spaceinvaders
folder_01.target = qml
DEPLOYMENTFOLDERS = folder_01

VERSION = 0.3.9
DEFINES+="MYVERSION=$${VERSION}"

QT += xml \
      network \
      script \
      svg \
      sql \
      xmlpatterns \
      gui \
      network \
      core \


# Additional import path used to resolve QML modules in Creator's code model
QML_IMPORT_PATH =

symbian {
    ICON = pgz-spaceinvaders.svg
    TARGET.UID3 = 0x2003AE1A

    #Use this uid when signing using custom certificate
    #TARGET.UID3 = 0xE656F302

    vendorinfo = \
    "%{\"Adam Pigg-EN\"}" \
    ":\"Adam Pigg\""

    # Remove all the existing platform dependencies
    default_deployment.pkg_prerules -= pkg_platform_dependencies

    #Add a dependency for just the S60 5th edition (Symbian^1) and later phones
    supported_platforms = \
    "; Application that only supports S60 5th edition" \
    "[0x1028315F],0,0,0,{\"S60ProductID\"}"

    my_deployment.pkg_prerules += supported_platforms
    my_deployment.pkg_prerules += vendorinfo
    DEPLOYMENT += my_deployment

    DEPLOYMENT.installer_header = 0x2002CCCF

TARGET.CAPABILITY = LocalServices \
    NetworkServices \
    UserEnvironment
}

# Define QMLJSDEBUGGER to allow debugging of QML in debug builds
# (This might significantly increase build time)
# DEFINES += QMLJSDEBUGGER

# If your application uses the Qt Mobility libraries, uncomment
# the following lines and add the respective components to the 
# MOBILITY variable. 
CONFIG += mobility
#MOBILITY += sensors

# The .cpp file which was generated for your project. Feel free to hack it.
SOURCES += main.cpp \
    Bunker.cpp \
    HiScores.cpp \
    HiScoreModel.cpp \
    Helper.cpp

# Please do not modify the following two lines. Required for deployment.
include(qmlapplicationviewer/qmlapplicationviewer.pri)
qtcAddDeployment()

include(installicons.pri)

OTHER_FILES += \
    qml/logic.js \
    qtc_packaging/debian_fremantle/changelog \
    qtc_packaging/debian_fremantle/control \
    android/res/drawable-hdpi/icon.png \
    android/res/drawable-ldpi/icon.png \
    android/res/values/strings.xml \
    android/res/values/libs.xml \
    android/res/drawable-mdpi/icon.png \
    android/AndroidManifest.xml \
    android/src/eu/licentia/necessitas/industrius/QtActivity.java \
    android/src/eu/licentia/necessitas/industrius/QtSurface.java \
    android/src/eu/licentia/necessitas/industrius/QtApplication.java \
    android/src/eu/licentia/necessitas/ministro/IMinistroCallback.aidl \
    android/src/eu/licentia/necessitas/ministro/IMinistro.aidl \
    android/res/drawable-hdpi/icon.png \
    android/res/drawable-ldpi/icon.png \
    android/res/values/strings.xml \
    android/res/values/libs.xml \
    android/res/drawable-mdpi/icon.png \
    android/AndroidManifest.xml \
    android/src/eu/licentia/necessitas/industrius/QtActivity.java \
    android/src/eu/licentia/necessitas/industrius/QtSurface.java \
    android/src/eu/licentia/necessitas/industrius/QtApplication.java \
    android/src/eu/licentia/necessitas/ministro/IMinistroCallback.aidl \
    android/src/eu/licentia/necessitas/ministro/IMinistro.aidl \
    android/AndroidManifest.xml \
    android/src/eu/licentia/necessitas/ministro/IMinistroCallback.aidl \
    android/src/eu/licentia/necessitas/ministro/IMinistro.aidl \
    android/src/eu/licentia/necessitas/mobile/QtCamera.java \
    android/src/eu/licentia/necessitas/mobile/QtSystemInfo.java \
    android/src/eu/licentia/necessitas/mobile/QtAndroidContacts.java \
    android/src/eu/licentia/necessitas/mobile/QtFeedback.java \
    android/src/eu/licentia/necessitas/mobile/QtLocation.java \
    android/src/eu/licentia/necessitas/mobile/QtMediaPlayer.java \
    android/src/eu/licentia/necessitas/mobile/QtSensors.java \
    android/src/eu/licentia/necessitas/industrius/QtActivity.java \
    android/src/eu/licentia/necessitas/industrius/QtSurface.java \
    android/src/eu/licentia/necessitas/industrius/QtApplication.java \
    android/src/eu/licentia/necessitas/industrius/QtLayout.java \
    android/res/drawable-mdpi/icon.png \
    android/res/drawable-hdpi/icon.png \
    android/res/drawable-ldpi/icon.png \
    android/res/values/libs.xml \
    android/res/values/strings.xml \
    qtc_packaging/debian_harmattan/rules \
    qtc_packaging/debian_harmattan/README \
    qtc_packaging/debian_harmattan/copyright \
    qtc_packaging/debian_harmattan/control \
    qtc_packaging/debian_harmattan/compat \
    qtc_packaging/debian_harmattan/changelog

HEADERS += \
    Bunker.h \
    HiScores.h \
    HiScoreModel.h \
    Helper.h
