import QtQuick 1.0
import "sizer.js" as Sizer;

Rectangle {
    id: hiscorepanel
    height: board.height - 80
    width:  board.width/1.5
    y: 50
    state: "HIDDEN"
    border.color: "#00ff00"
    border.width: 5
    color:  "black"

    states: [
        State {
            name: "HIDDEN"
            PropertyChanges { target: hiscorepanel; x: board.width + 2}
        },
        State {
            name: "VISIBLE"
            PropertyChanges { target: hiscorepanel; x: board.width - width}
        }
    ]

    transitions: Transition {
        NumberAnimation { properties: "x"; easing.type: Easing.InOutQuad }
    }

    //Dummy mouse area to stop events being passed through
    MouseArea {
        anchors.fill: parent
    }

    Text {
        id: hiscoreheader
        text: "Local Hi Scores"
        font.pixelSize: Sizer.largeFontSize()
        anchors.horizontalCenter: hiscorepanel.horizontalCenter
        anchors.top: hiscorepanel.top
        anchors.topMargin: 5
        color:  "#00ff00"
    }

    Text {
        id: lvl
        text: "Level"
        font.pixelSize: Sizer.largeFontSize()

        anchors.top: hiscoreheader.bottom
        anchors.topMargin: 10
        anchors.left: pos1.right
        anchors.leftMargin: 30
        color:  "#00ff00"
    }

    Text {
        id: score
        text: "Score"
        font.pixelSize: Sizer.largeFontSize()

        anchors.top: hiscoreheader.bottom
        anchors.topMargin: 10
        anchors.left: lvl.right
        anchors.leftMargin: 30
        color:  "#00ff00"
    }

    Text {
        id: scrdate
        text: "Date"
        font.pixelSize: Sizer.largeFontSize()

        anchors.top: hiscoreheader.bottom
        anchors.topMargin: 10
        anchors.left: score.right
        anchors.leftMargin: 40
        color:  "#00ff00"
    }

    Text {
        id: pos1
        text: "1."
        font.pixelSize: Sizer.largeFontSize()
        x: 20
        anchors.top: lvl.bottom
        anchors.topMargin: 10
        color:  "#00ff00"
    }

    Text {
        id: pos2
        text: "2."
        font.pixelSize: Sizer.largeFontSize()
        x: 20
        anchors.top: pos1.bottom
        anchors.topMargin: 10
        color:  "#00ff00"
    }

    Text {
        id: pos3
        text: "3."
        font.pixelSize: Sizer.largeFontSize()
        x: 20
        anchors.top: pos2.bottom
        anchors.topMargin: 10
        color:  "#00ff00"
    }

    Text {
        id: pos4
        text: "4."
        font.pixelSize: Sizer.largeFontSize()
        x: 20
        anchors.top: pos3.bottom
        anchors.topMargin: 10
        color:  "#00ff00"
    }

    Text {
        id: pos5
        text: "5."
        font.pixelSize: Sizer.largeFontSize()
        x: 20
        anchors.top: pos4.bottom
        anchors.topMargin: 10
        color:  "#00ff00"
    }

    Text {
        id: pos6
        text: "6."
        font.pixelSize: Sizer.largeFontSize()
        x: 20
        anchors.top: pos5.bottom
        anchors.topMargin: 10
        color:  "#00ff00"
    }

    Text {
        id: pos1lvl
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos1.top
        anchors.left: pos1.right
        anchors.leftMargin: 30
        color:  "#00ff00"
    }

    Text {
        id: pos2lvl
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos2.top
        anchors.left: pos2.right
        anchors.leftMargin: 30
        color:  "#00ff00"
    }

    Text {
        id: pos3lvl
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos3.top
        anchors.left: pos3.right
        anchors.leftMargin: 30
        color:  "#00ff00"
    }

    Text {
        id: pos4lvl
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos4.top
        anchors.left: pos4.right
        anchors.leftMargin: 30
        color:  "#00ff00"
    }

    Text {
        id: pos5lvl
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos5.top
        anchors.left: pos5.right
        anchors.leftMargin: 30
        color:  "#00ff00"
    }

    Text {
        id: pos6lvl
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos6.top
        anchors.left: pos6.right
        anchors.leftMargin: 30
        color:  "#00ff00"
    }

    Text {
        id: pos1scr
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos1.top
        anchors.left: score.left
        color:  "#00ff00"
    }

    Text {
        id: pos2scr
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos2.top
        anchors.left: score.left
        color:  "#00ff00"
    }

    Text {
        id: pos3scr
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos3.top
        anchors.left: score.left
        color:  "#00ff00"
    }

    Text {
        id: pos4scr
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos4.top
        anchors.left: score.left
        color:  "#00ff00"
    }

    Text {
        id: pos5scr
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos5.top
        anchors.left: score.left
        color:  "#00ff00"
    }

    Text {
        id: pos6scr
        text: "0"
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos6.top
        anchors.left: score.left
        color:  "#00ff00"
    }

    Text {
        id: pos1dt
        text: ""
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos1.top
        anchors.left: scrdate.left
        color:  "#00ff00"
    }

    Text {
        id: pos2dt
        text: ""
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos2.top
        anchors.left: scrdate.left
        color:  "#00ff00"
    }

    Text {
        id: pos3dt
        text: ""
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos3.top
        anchors.left: scrdate.left
        color:  "#00ff00"
    }

    Text {
        id: pos4dt
        text: ""
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos4.top
        anchors.left: scrdate.left
        color:  "#00ff00"
    }

    Text {
        id: pos5dt
        text: ""
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos5.top
        anchors.left: scrdate.left
        color:  "#00ff00"
    }

    Text {
        id: pos6dt
        text: ""
        font.pixelSize: Sizer.largeFontSize()
        x: 30
        anchors.top: pos6.top
        anchors.left: scrdate.left
        color:  "#00ff00"
    }


    Image {
        id: uploadscoreimage
        source: "pics/world-arrow.png"
        anchors.verticalCenter: pos1.verticalCenter
        anchors.right: parent.right
        anchors.rightMargin: 10
        height: 40
        width: 70

        MouseArea {
            id: uploadscorearea
            anchors.fill: parent
            onClicked: {
                board.displayMessage("Please Wait...");
                messagetimer.start();

                HiScores.sendHiScore(gamerName, password, pos1Level, pos1Score, pos1Date)
            }
        }
    }

    function refreshScores() {
        pos1lvl.text = pos1Level;
        pos1scr.text = pos1Score;
        pos1dt.text = pos1Date;

        pos2lvl.text = pos2Level;
        pos2scr.text = pos2Score;
        pos2dt.text = pos2Date;

        pos3lvl.text = pos3Level;
        pos3scr.text = pos3Score;
        pos3dt.text = pos3Date;

        pos4lvl.text = pos4Level;
        pos4scr.text = pos4Score;
        pos4dt.text = pos4Date;

        pos5lvl.text = pos5Level;
        pos5scr.text = pos5Score;
        pos5dt.text = pos5Date;

        pos6lvl.text = pos6Level;
        pos6scr.text = pos6Score;
        pos6dt.text = pos6Date;
    }

    Component.onCompleted: refreshScores();

}
