#include <QtGui/QApplication>
#include "qmlapplicationviewer.h"
#include <QDeclarativeEngine>
#include <QDeclarativeContext>
#include "Bunker.h"
#include "HiScores.h"
#include "HiScoreModel.h"

int main(int argc, char *argv[])
{
    //qputenv("N900_PORTRAIT_SENSORS", "1");

    QApplication app(argc, argv);

    qmlRegisterType<Bunker>("SpaceInvaders", 1, 0, "Bunker");

    QmlApplicationViewer viewer;
    HiScores hiscores;
    HiScoreModel globalhiscores;

    viewer.rootContext()->setContextProperty("HiScores", &hiscores);
    viewer.rootContext()->setContextProperty("GlobalHiScores", &globalhiscores);

    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationLockLandscape);

    viewer.engine()->addImportPath(QString("/opt/qtm12/imports"));

    viewer.setResizeMode(QDeclarativeView::SizeRootObjectToView);
    viewer.setGeometry(100, 100, 640, 320);
    viewer.setMainQmlFile(QLatin1String("qml/pgz-spaceinvaders/main.qml"));
    viewer.showExpanded();

    return app.exec();
}
