import QtQuick 1.0
import "storage.js" as Settings;
import "sizer.js" as Sizer;

Rectangle {
    id: settingspanel
    height: board.height - 100
    width:  board.width/2
    y: 50
    state: "HIDDEN"
    border.color: "#00ff00"
    border.width: 5
    color:  "black"


    states: [
        State {
            name: "HIDDEN"
            PropertyChanges { target: settingspanel; x: board.width + 2}
        },
        State {
            name: "VISIBLE"
            PropertyChanges { target: settingspanel; x: board.width/2}
        }


    ]

    transitions: Transition {
        NumberAnimation { properties: "x"; easing.type: Easing.InOutQuad }
    }

    //Dummy mouse area to stop events being passed through
    MouseArea {
        anchors.fill: parent
    }
    //Flash Setting
    Rectangle {
        id: flashoption
        height: 40
        width: 40
        x: 40

        anchors.top: parent.top;
        anchors.topMargin: 40;

        border.color: "#00ff00"
        border.width: 5
        state: "FALSE"

        states: [
            State {
                name: "TRUE"
                PropertyChanges { target: flashoption; color: "#00ff00"}
            },
            State {
                name: "FALSE"
                PropertyChanges { target: flashoption; color: "#000000"}
            }
        ]

        MouseArea {
            anchors.fill: parent
            onClicked: {
                if (flashoption.state == "FALSE") {
                    flashoption.state = "TRUE";
                    Settings.FlashOnFire = "TRUE";
                } else {
                    flashoption.state = "FALSE";
                    Settings.FlashOnFire = "FALSE";
                }
                Settings.saveSettings();
            }
        }

    }
    Text {
        id: flashoptiontext
        text: "Flash on fire"
        font.pixelSize: Sizer.largeFontSize()
        color: "#00ff00"
        anchors.left: flashoption.right
        anchors.leftMargin: 20
        anchors.top: flashoption.top
    }

    //Acceleromter Setting
    Rectangle {
        id: accelerometeroption
        height: 40
        width: 40
        x: 40

        anchors.top: flashoption.bottom;
        anchors.topMargin: 40;

        border.color: "#00ff00"
        border.width: 5
        state: "FALSE"

        states: [
            State {
                name: "TRUE"
                PropertyChanges { target: accelerometeroption; color: "#00ff00"}
            },
            State {
                name: "FALSE"
                PropertyChanges { target: accelerometeroption; color: "#000000"}
            }
        ]

        MouseArea {
            anchors.fill: parent
            onClicked: {
                if (accelerometeroption.state == "FALSE") {
                    accelerometeroption.state = "TRUE";
                    Settings.UseAccelerometer = "TRUE";
                } else {
                    accelerometeroption.state = "FALSE";
                    Settings.UseAccelerometer = "FALSE";
                }
                Settings.saveSettings();
            }
        }

    }
    Text {
        id: accelerometeroptiontext
        text: "Use Accelerometer"
        font.pixelSize: Sizer.largeFontSize()
        color: "#00ff00"
        anchors.left: accelerometeroption.right
        anchors.leftMargin: 20
        anchors.top: accelerometeroption.top
    }

    //SFX Setting
    Rectangle {
        id: sfxoption
        height: 40
        width: 40
        x: 40

        anchors.top: accelerometeroption.bottom;
        anchors.topMargin: 40;

        border.color: "#00ff00"
        border.width: 5
        state: "FALSE"

        states: [
            State {
                name: "TRUE"
                PropertyChanges { target: sfxoption; color: "#00ff00"}
            },
            State {
                name: "FALSE"
                PropertyChanges { target: sfxoption; color: "#000000"}
            }
        ]

        MouseArea {
            anchors.fill: parent
            onClicked: {
                if (sfxoption.state == "FALSE") {
                    sfxoption.state = "TRUE";
                    Settings.SFX = "TRUE";
                } else {
                    sfxoption.state = "FALSE";
                    Settings.SFX = "FALSE";
                }
                Settings.saveSettings();
            }
        }

    }
    Text {
        id: sfxoptiontext
        text: "Sound Effects"
        font.pixelSize: Sizer.largeFontSize()
        color: "#00ff00"
        anchors.left: sfxoption.right
        anchors.leftMargin: 20
        anchors.top: sfxoption.top
    }


    function startupFunction() {
        Settings.initialize();
        Settings.loadSettings();
        accelerometeroption.state = Settings.UseAccelerometer;
        flashoption.state = Settings.FlashOnFire;
        sfxoption.state = Settings.SFX;

    }

    Component.onCompleted: startupFunction();

}
