
var direction = 0;
var component;
var bullet;
var aliendirection = 1;

var aliens = new Array(10*5);
var state = "stopped";

var bombs = new Array(10); //Max of 10 bombs on screen at one time
var score = 0;
var dropBombChance = 2; //start chance of and alien dropping a bomb

var level = 0;
var startlives = 3; //Edit this to cheat!
var livesindication = new Array(startlives - 1);
var lives;

function createLivesIndication() {
    var px = 0;
    var py = 0;

    py = board.height - ship.height;

    for (var i = 0; i < startlives-1; ++i) {
        px = i * (ship.width + 20);

        var component = Qt.createComponent("Ship.qml");
        livesindication[i] = component.createObject(board);

        if ( livesindication[i] == null) {
            // Error Handling
            console.log("Error creating life ship");
        }
        if (livesindication[i]) {
                livesindication[i].x = px;
                livesindication[i].y = py;
        }

    }
}

function destroyLivesIndication() {
    for (var i = 0; i < startlives-1; ++i) {
        if(livesindication[i]) {
            livesinidication[i].destroy();
            livesindication[i] = null;
        }
    }
}

function shipHit() {
    if (Settings.SFX == "TRUE"){
        destroyShipSound.play();
    }

    if (lives > 1) {
        lives--;
        if (livesindication[lives - 1]) {
            livesindication[lives - 1].destroy();
            livesindication[lives - 1] = null
            lifelosttimer.start();
        }

    } else { //game over
        endGame(true);
    }
}

//Load the bullet QML and position it at the centre of the ship
function createBullet() {
    //If there is no bullet, create one
    if (bullet == null ) {
        component = Qt.createComponent("bullet.qml");

        bullet = component.createObject(board);

        if ( bullet == null) {
            // Error Handling
            console.log("Error creating object");
        }
        if (bullet) {
                bullet.x = ship.x + ship.width/2 - bullet.width/2;
                bullet.y = ship.y;
        }
    }

    //If the exisiting bullet is not off screen do nothing
    if (bullet.y > -10) {
        return;
    } else { //Reset bullet position
        if (Settings.FlashOnFire == "TRUE") {
            flashanim.start();
        }

        if (Settings.SFX == "TRUE"){
            shootSound.play();
        }
        bullet.x = ship.x + ship.width/2 - bullet.width/2;
        bullet.y = ship.y
    }

}

//Create all aliens and position them on the board in rows
function createAliens() {

    //Row 1
    component = Qt.createComponent("alien1.qml");
    for (var i=0; i<10; i++) {
        aliens[i] = component.createObject(board);
        aliens[i].x = ((aliens[i].width + 10) * i) + 10;
        aliens[i].y = 50;
    }

    //Row 2
    component = Qt.createComponent("alien2.qml");
    for (var i=0; i<10; i++) {
        aliens[i+10] = component.createObject(board);
        aliens[i+10].x = ((aliens[i+10].width + 10) * i) + 10;
        aliens[i+10].y = 100;
    }

    //Row 3
    for (var i=0; i<10; i++) {
        aliens[i+20] = component.createObject(board);
        aliens[i+20].x = ((aliens[i+20].width + 10) * i) + 10;
        aliens[i+20].y = 150;
    }

    //Row 4
    component = Qt.createComponent("alien3.qml");
    for (var i=0; i<10; i++) {
        aliens[i+30] = component.createObject(board);
        aliens[i+30].x = ((aliens[i+30].width + 10) * i) + 10;
        aliens[i+30].y = 200;
    }

    //Row 5
    for (var i=0; i<10; i++) {
        aliens[i+40] = component.createObject(board);
        aliens[i+40].x = ((aliens[i+40].width + 10) * i) + 10;
        aliens[i+40].y = 250;
    }


}

function rand(n)
{
  return (Math.floor(Math.random() * n));
}

function scheduleDirection(dir)
{
    direction = dir;
}

function fire()
{
    if (state == "started") {
        createBullet();
    }
}

function startGame()
{
    if (state == "started")
        return;

    if (state == "stopped") {

        Settings.loadSettings();

        //Reset the score
        score = 0;
        scoretext.text = "Score: " + score;

        //Reset the level
        level = 1;
        leveltext.text = "Level: " + level;

        //Reset the alien speed and chance of dropping a bomb
        alienanimation.interval = 600;
        dropBombChance = 100;

        lives = startlives;
        destroyLivesIndication();
        createLivesIndication();
    }

    //Hide the seetings button when the game starts
    settingsbutton.visible = false;
    settingspanel.state = "HIDDEN";
    hiscorebutton.visible = false;
    hiscorepanel.state = "HIDDEN";

    Bunker1.create(96, 340, board);
    Bunker2.create((96*2) + 80, 340, board);
    Bunker3.create((96*3) + 160, 340, board);
    Bunker4.create((96*4) + 220, 340, board);

    starttext.visible = false;
    createAliens();

    //Start the animation timers
    heartbeat.running = true;
    alienanimation.running = true;

    //Enable or disable the acceleromter
    Settings.loadSettings();
    if (Settings.UseAccelerometer == "TRUE" ) {
        accelerometer.start();
    } else {
        accelerometer.stop();
    }

    gameover.visible = false;

    state = "started";
}

function endGame(dead)
{
    state = "stopped";

    //Stop the animation timers
    heartbeat.running = false;
    alienanimation.running = false;

    destroyAliens();
    cleanupBombs();
    Bunker1.destroyBunker();
    Bunker2.destroyBunker();
    Bunker3.destroyBunker();
    Bunker4.destroyBunker();

    if (dead) {
        gameover.text = "GAME OVER"
    } else  {
        gameover.text = "COMPLETE"
    }

    //Show the seetings button when the game ends
    settingsbutton.visible = true;
    settingspanel.state = "HIDDEN";
    hiscorebutton.visible = true;
    hiscorepanel.state = "HIDDEN";

    Settings.addNewScore(level, score);
    hiscorepanel.refreshScores();

    deadtimer.start();
    gameover.visible = true;
}

function nextLevel()
{
//    if (level < 5) {
        state = "waitingforlevelstart"

    //Remove the bunkers
    Bunker1.destroyBunker();
    Bunker2.destroyBunker();
    Bunker3.destroyBunker();
    Bunker4.destroyBunker();

        starttext.visible = true;

        level++;
        leveltext.text = "Level: " + level;

        heartbeat.running = false;
        alienanimation.running = false;

        cleanupBombs();

        if (alienanimation.interval > 400) {
            alienanimation.interval = 800 - (level * 50)
        }

        if (dropBombChance > 50) {
            dropBombChance -= 10; //drop more bombs!
        }
//    } else {
//        endGame(false);
//    }

}

function mainEvent() {
    move();
    moveBombs();
    moveBullet();
    checkCollisions();

    if (state == "started") {
        checkComplete();
    }
}

function moveBombs() {
    for (var i = 0; i < 10; ++i) {
        if (bombs[i]) {
            if (bombs[i].y  < board.height + 40) {
               bombs[i].y += 10;
            } else {
               bombs[i].destroy();
               bombs[i] = null;
            }
        }
    }
}

function moveBullet() {
    if (bullet) {
        if (bullet.y > -20){
           bullet.y -= 18;
        }
    }
}

function checkComplete() {
    var count = 0;
    for (var i=0; i<50; i++) {
        if(aliens[i]) {
            count++;
        }
    }

    if(count == 0) {
        //Complete!
        nextLevel();
    }
}

function checkCollisions() {
    checkBulletAlienCollision();
    checkBombShipCollision();
    checkBombBunkerCollision();
    checkBulletBunkerCollision();
}

function checkBulletAlienCollision() {
    //Loop over each alien, checking if the bullet intersects

    for (var i=0; i<50; i++) {
        if (bullet && aliens[i]) { //Check if objects exist first
            if (bullet.x > aliens[i].x && bullet.x < aliens[i].x + aliens[i].width) {
                if (bullet.y > aliens[i].y && bullet.y < aliens[i].y + aliens[i].height) {
                    if (Settings.SFX == "TRUE"){
                        destroyAlienSound.play();
                    }

                    aliens[i].destroy();
                    aliens[i] = null;
                    score += 100;
                    scoretext.text = "Score: " + score;
                    bullet.y = -20; //Move the bullet offscreen

                    if (alienanimation.interval > 400) { //Get faster when a alien is killed
                        alienanimation.interval -= 5;
                    }
                    break;
                }
            }
        }
    }
}

function checkBombShipCollision() {
    //Loop over each bomb checking if it has hit the ship
    for (var i=0; i<10; i++) {
        if (bombs[i]) { //Check if bomb object exist first
            if (bombs[i].x > ship.x && bombs[i].x < ship.x + ship.width) {
                if (bombs[i].y > ship.y && bombs[i].y < ship.y + ship.height) {
                    bombs[i].destroy();
                    bombs[i] = null;
                    shipHit();
                    break;
                }
            }
        }
    }
}

function checkBombBunkerCollision() {
    //Loop over each bomb checking if it has hit the ship
    for (var i=0; i<10; i++) {
        if (bombs[i]) { //Check if bomb object exist first
            var x = bombs[i].x;
            var y = bombs[i].y;
            var w = bombs[i].width;
            var h = bombs[i].height;

            if (x >= Bunker1.x - w && x <= Bunker1.x + Bunker1.width){
                if (Bunker1.checkBunkerHit(x, y, w, h)) {
                    bombs[i].destroy();
                    bombs[i] = null;
                    continue;
                }
            }

            if (x >= Bunker2.x - w && x <= Bunker2.x + Bunker2.width){
                if (Bunker2.checkBunkerHit(x, y, w, h)) {
                    bombs[i].destroy();
                    bombs[i] = null;
                    continue;
                }
            }

            if (x >= Bunker3.x - w && x <= Bunker3.x + Bunker3.width){
                if (Bunker3.checkBunkerHit(x, y, w, h)) {
                    bombs[i].destroy();
                    bombs[i] = null;
                    continue;
                }
            }

            if (x >= Bunker4.x - w && x <= Bunker4.x + Bunker4.width){
                if (Bunker4.checkBunkerHit(x, y, w, h)) {
                    bombs[i].destroy();
                    bombs[i] = null;
                    continue;
                }
            }
        }
    }
}

function checkBulletBunkerCollision() {
    if (bullet) { //Check if bomb object exist first
        var x = bullet.x;
        var y = bullet.y;
        var w = bullet.width;
        var h = bullet.height;

        if (Bunker1.checkBunkerHitRev(x, y, w, h)) {
            bullet.y = -20;
        }
        else if (Bunker2.checkBunkerHitRev(x, y, w, h)) {
            bullet.y = -20;
        }
        else if (Bunker3.checkBunkerHitRev(x, y, w ,h)) {
            bullet.y = -20;
        }
        else if (Bunker4.checkBunkerHitRev(x, y, w, h)) {
            bullet.y = -20;
        }
    }

}

function moveAliens() {

    //Find out if the direction needs changed
    if (aliendirection == 1) {
        for (var i=0; i<50; i++) {
            if (aliens[i]) {
                if (aliens[i].x + aliens[i].width > board.width - 10) {
                    aliendirection = -1;
                }
            }
        }
    } else {
        for (var i=0; i<50; i++) {
            if (aliens[i]) {
                if (aliens[i].x < 10) {
                    aliendirection = 1;

                    //Drop by 5px
                    for (var i=0; i<50; i++) {
                        if (aliens[i]) {
                           aliens[i].y += 5;
                        }
                    }

                }
            }
        }
    }

    //Move the aliens
    for (var i=0; i<50; i++) {
        if (aliens[i]) {
            aliens[i].x += 10 * aliendirection;

            //Change the state to the other frame
            if (aliens[i].state == "FRAME0") {
                aliens[i].state = "FRAME1";
            } else {
                aliens[i].state = "FRAME0";
            }
        }
    }

    dropBomb();

}

function dropBomb() {
    for (var i = 0; i < 50; ++i) {

        if (aliens[i]) {

            var chance = rand(dropBombChance);
            if (chance == 1) {
                var slot = -1;

                //Check if there is space to store the bomb
                for (var j=0; j<10; j++) {
                    if (!bombs[j]) {
                        slot = j;
                        break;
                    }
                }

                if (slot >= 0) {
                    component = Qt.createComponent("bomb.qml");

                    var bomb = component.createObject(board);

                    if ( bomb == null) {
                        // Error Handling
                        console.log("Error creating bomb");
                    }
                    if (bomb) {
                            bomb.x = aliens[i].x + aliens[i].width/2 - bomb.width/2;
                            bomb.y = aliens[i].y + aliens[i].height;
                            bombs[slot] = bomb;

                    }

                }
            }
        }
    }
}

function cleanupBombs() {
    for (var i=0; i<10; i++) {
        if (bombs[i]) {
            bombs[i].destroy();
            bombs[i] = null;
        }
    }
}

function destroyAliens() {
    for (var i=0; i<50; i++) {
        if (aliens[i]){
            aliens[i].destroy();
            aliens[i] = null;
        }
    }
}

function move() {
    if ((direction < 0 && ship.x > (direction * -1)) || (direction > 0 && (ship.x + ship.width + direction < board.width))) {
            ship.x += direction;
    }

    direction = 0;
}

