#ifndef LATITUDESETTINGS_H
#define LATITUDESETTINGS_H

#include <QDialog>
#include <QtLocation/QGeoPositionInfoSource>

class QPushButton;
class QLabel;
class QHBoxLayout;
class QVBoxLayout;
class QSpinBox;
class QComboBox;

using namespace QtMobility;

class LatitudeSettings : public QDialog
{
    Q_OBJECT
public:
    explicit LatitudeSettings(QWidget *parent = 0);
    ~LatitudeSettings();

    int updateInterval();
    QGeoPositionInfoSource::PositioningMethod positioningMethod();

    void setUpdateIterval(int minutes);
    void setPositioningMethod(QGeoPositionInfoSource::PositioningMethod method);
signals:
    void authorize();

public slots:

private slots:
    void slotAuthorize();

private:
    QPushButton *m_authButton;
    QHBoxLayout *m_hlayout1;
    QHBoxLayout *m_hlayout2;
    QHBoxLayout *m_hlayout3;
    QVBoxLayout *m_vlayout;
    QComboBox *m_method;
    QSpinBox *m_refresh;
    QPushButton *m_okButton;
};

#endif // LATITUDESETTINGS_H
