var component;

var startlives = 3; //Edit this to cheat!
var livesindication = new Array(startlives - 1);
var lives;

var direction;

var blocks = new Array();

function cmdNotRunning() {
    gameState = "NOTRUNNING";
    gameBoard.currentLevel = 0;

    starttext.visible = true;

    //Stop the animation timers
    heartbeat.running = false;

    board.hideMessage();
}

function cmdNewGame() {
    gameState = "NEWGAME";

    //Reset the score
    gameBoard.score = 0;

    //Reset the level
    gameBoard.currentLevel = 0;

    lives = startlives;
    destroyLivesIndication();
    createLivesIndication();

    cmdStartNewLevel();
}

function cmdRunning() {
    gameState = "RUNNING";

    //Hide all panels
    /*
    messagecontainer.state = "HIDDEN"
    settingspanel.state = "HIDDEN";
    hiscorepanel.state = "HIDDEN";
    menupanel.state = "HIDDEN";
    globalhiscorepanel.state = "HIDDEN";
    */

    //Start the animation timers
    heartbeat.running = true;

    //Enable or disable the acceleromter
    if (useAccelerometer == "TRUE" ) {
        accelerometer.start();
    } else {
        accelerometer.stop();
        thepaddle.direction = 0;
    }

    thechick.reset();

}

function cmdLifeLost() {
    gameState = "LIFELOST";
    lives--;
    if (livesindication[lives - 1]) {
        livesindication[lives - 1].destroy();
        livesindication[lives - 1] = null
    }
    board.displayMessage("Life Lost");

    //Stop the animation timers
    heartbeat.running = false;
}

function cmdDead() {
    gameState = "DEAD"

    //Stop the animation timers
    heartbeat.running = false;

    board.displayMessage("GAME OVER");

    //gameBoard.addNewScore(level, gameBoard.score);
    //hiscorepanel.refreshScores();

    destroyLevel();

    deadtimer.restart();
}

function cmdResume() {
    cmdRunning();
}

function cmdLevelComplete() {
    gameState = "LEVELCOMPLETE";

    starttext.visible = true;

    heartbeat.running = false;

    gameBoard.showScoreBoard();
    gameBoard.score+=calculateLevelScore();
}

function cmdStartNewLevel() {
    gameState = "LEVELSTARTING";


    //See if the game has ended
    if (gameBoard.currentLevel == gameBoard.numLevels) {
        cmdGameComplete();
        return;
    }

    gameBoard.currentLevel++;

    starttext.visible = false;

    if (LevelLoader.levelExists(selectedLevelPack, gameBoard.currentLevel)) {
        loadLevel(selectedLevelPack, gameBoard.currentLevel);

        //Enable or disable the acceleromter
        if (useAccelerometer == "TRUE" ) {
            accelerometer.start();
        } else {
            accelerometer.stop();
            direction = 0;
        }

        cmdRunning();
    } else {
        console.log("unable to load level");
        cmdNotRunning();
    }

}

function cmdGameComplete() {
    gameState = "GAMECOMPLETE";
    gameBoard.displayMessage("Game Complete!");
}

function cmdPause() {
    gameState = "PAUSED";
    board.displayMessage("Paused");

    //Start the animation timers
    heartbeat.running = false;
}

function screenTap() {
    if (messagecontainer.state == "VISIBLE") {
        board.hideMessage();
        return;
    }

    //!TODO
    /*
    if (settingspanel.state == "VISIBLE" || hiscorepanel.state == "VISIBLE" || menupanel.state == "VISIBLE" || globalhiscorepanel.state == "VISIBLE") {
        settingspanel.state = "HIDDEN";
        hiscorepanel.state = "HIDDEN";
        menupanel.state = "HIDDEN";
        globalhiscorepanel.state = "HIDDEN";

        return;
    }
*/
    if (levelScoreBoard.state == "VISIBLE") {
        gameBoard.hideScoreBoard();
        return;
    }

    if (gameState == "NOTRUNNING") {
         cmdNewGame();
    } else if (gameState == "LIFELOST" || gameState == "PAUSED") {
        cmdResume();
    } else if (gameState == "LEVELCOMPLETE") {
        cmdStartNewLevel();
    } else if (gameState == "RUNNING") {
         fire();
    } else if (gameState == "GAMECOMPLETE") {
        mainBoard.endGame();
    }
}

function createLivesIndication() {
    var px = 0;
    var py = 0;

    py = board.height - Sizer.chickSize();

    for (var i = 0; i < startlives-1; ++i) {
        px = i * (Sizer.chickSize());

        var component = Qt.createComponent("Chick.qml");
        livesindication[i] = component.createObject(board);

        if ( livesindication[i] == null) {
            // Error Handling
            console.log("Error creating life ship");
        }
        if (livesindication[i]) {
                livesindication[i].x = px;
                livesindication[i].y = py;
        }

    }
}

function destroyLivesIndication() {
    for (var i = 0; i < startlives-1; ++i) {
        if(livesindication[i]) {
            livesindication[i].destroy();
            livesindication[i] = null;
        }
    }
}

function rand(n)
{
  return (Math.floor(Math.random() * n));
}

function scheduleDirection(dir)
{
    thepaddle.direction = dir;
}

function fire()
{
    thechick.moving = true;
}

function mainEvent() {
    if (gameState == "RUNNING") {
        Helper.setBlankingPause();
        move();
        checkCollisions();
        moveChick();

        //Total up the runnind time
        gameBoard.timeTaken += 40/1000;

        checkComplete();
    }
}

function moveChick()
{
    if (thechick.moving) {
        thechick.x += thechick.xspeed;
        thechick.y += thechick.yspeed;
    } else {
        thechick.x = (thepaddle.x + thepaddle.width / 2) - thechick.width/2
        thechick.y = thepaddle.y - thechick.height
    }

}

function checkComplete() {
    if (gameState == "RUNNING") {
        var count = 0;

        for (var i = 0; i < blocks.length; i++) {
            if (blocks[i]) {
                if(blocks[i].strength > 0) {
                    count++;
                }
            }
        }

        if(count == 0) {
            //Complete!
            cmdLevelComplete();
        }
    }
}

function checkCollisions()
{
    checkChickWallCollision();
    checkChickBlockCollision();
    checkChickPaddleCollision();
}

function checkChickBlockCollision()
{
    if (thechick.moving)
    {
        var chickRadius = thechick.width / 2;
        var chickCentreX = thechick.x + chickRadius;
        var chickCentreY = thechick.y + chickRadius;

        for (var i = 0; i < blocks.length; i++) {
            var block = blocks[i];


            if (block) {
                if (block.strength > 0) {
                    if (thechick.yspeed < 0) { // Moving Upwards
                        if ((Math.abs(chickCentreY - (block.y + block.height)) < chickRadius - 2) &&
                                (chickCentreX > block.x) &&
                                (chickCentreX < block.x + block.width)) {
                            thechick.yspeed *= -1;
                            block.hit();
                            scoreHit(block);
                            return
                        }
                    }

                    if (thechick.yspeed > 0) { // Moving Downwards
                        if ((Math.abs(chickCentreY - block.y) < chickRadius - 2) &&
                                (chickCentreX > block.x) &&
                                (chickCentreX < block.x + block.width)) {
                            thechick.yspeed *= -1;
                            block.hit();
                            scoreHit(block);
                            return
                        }
                    }

                    if (thechick.xspeed < 0) { // Moving Left
                        if ((Math.abs(chickCentreX - (block.x + block.width)) < chickRadius - 2) &&
                                (chickCentreY > block.y) &&
                                (chickCentreY < block.y + block.height)) {
                            thechick.xspeed *= -1;
                            block.hit();
                            scoreHit(block);
                            return
                        }
                    }

                    if (thechick.xspeed > 0) { // Moving Right
                        if ((Math.abs(chickCentreX - block.x) < chickRadius - 2) &&
                                (chickCentreY > block.y) &&
                                (chickCentreY < block.y + block.height)) {
                            thechick.xspeed *= -1;
                            block.hit();
                            scoreHit(block);
                            return
                        }
                    }
                }
            }
        }

    }
}

function checkChickPaddleCollision() {

    if (thechick.yspeed > 0){ //Moving towards paddle
        var chickRadius = thechick.width / 2;
        var chickCentreX = thechick.x + chickRadius;
        var chickCentreY = thechick.y + chickRadius;

        if (chickCentreX < thepaddle.x || chickCentreX > thepaddle.x + thepaddle.width) {
            return;
        }

        if (Math.abs(chickCentreY - thepaddle.y) < chickRadius) {
            thechick.yspeed *= -1

            var tm = (((chickCentreX - thepaddle.x)/thepaddle.width) * 20) - 10
            thechick.xspeed += tm;

            if (thechick.xspeed > 10) {
                thechick.xspeed = 10;
            }
            if (thechick.xspeed < -10) {
                thechick.xspeed = -10;
            }

            splatSound.play();

            return;
        }
    }
}

function checkChickWallCollision()
{
    var dirChange = false;

    if (thechick.moving) {
        if ((thechick.xspeed < 0 && thechick.x < 0) || (thechick.xspeed > 0 && thechick.x > (board.width - thechick.width))) {
            thechick.xspeed *= -1;
            dirChange = true;
        }
        if (thechick.yspeed < 0 && thechick.y < topLine.y) {
            thechick.yspeed *= -1;
            dirChange = true;
        }
        if (thechick.y > board.height) {
            cmdLifeLost();
        }

        if (dirChange) {
            splatSound.play();
        }
    }
}

function move() {
    if ((thepaddle.direction < 0 && thepaddle.x > 0) || (thepaddle.direction > 0 && (thepaddle.x + thepaddle.width < board.width))) {
            thepaddle.x += thepaddle.direction;
    }
}

function loadLevel(selectedLevelPack, lvl)
{
    component = Qt.createComponent("Block.qml");

    var xoffset = 0
    var yoffset = 10;
    var block_index = 0;

    var levelData = LevelLoader.loadLevel(selectedLevelPack, lvl);
    levelData = levelData.replace("\n", "");
    levelData = levelData.replace("\r", "");
    levelData = levelData.split(",");

    for(var i = 0; i < levelData.length; i++){

        if (i % 15 === 0) {
            yoffset += Sizer.blockGap() + Sizer.blockHeight();
            xoffset = Sizer.blockGap();
        }

        if (levelData[i] > 0) {
            blocks[block_index] = component.createObject(board);
            blocks[block_index].x = xoffset;
            blocks[block_index].y = yoffset;
            blocks[block_index].width=Sizer.blockWidth();
            blocks[block_index].height=Sizer.blockHeight();
            blocks[block_index].strength = levelData[i];
            blocks[block_index].init();
            block_index++;
        }

        xoffset += Sizer.blockWidth() + Sizer.blockGap();
    }
}

function destroyLevel()
{
    var blockCount = blocks.length;

    for (var i = 0; i < blockCount; ++i) {
        if (blocks[0] !== null) {
            blocks[0].blowUp();
            blocks[0].destroy();
            blocks[0] = null;
        }
        blocks.shift();
    }
}

function scoreHit(block)
{
    if (block.strength === 0) {
        if (block.type == "bale") {
            board.numBales++;
        } else if (block.type == "wood") {
            board.numPlanks++;
        } else if (block.type == "brick") {
            board.numBricks++;
        }
    }
}


function calculateLevelScore()
{
    var tmp = (board.numBales * 10) + (board.numPlanks * 20) + (board.numBricks);
    tmp = tmp + (tmp * (60 / timeTaken));

    return tmp;
}
