#include <QtGui/QApplication>
#include "qmlapplicationviewer.h"
#include <QDeclarativeEngine>
#include <QDeclarativeContext>
#include "Loader.h"
#include "Helper.h"
#include "LevelPackModel.h"
#include <QtOpenGL/QGLWidget>

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QCoreApplication::setOrganizationName("PGZ");
    QCoreApplication::setOrganizationDomain("piggz.co.uk");
    QCoreApplication::setApplicationName("pgz-farmbreakout");

    Loader loader;
    Helper helper;
    LevelPackModel levelPacks(loader.adjustPath("qml/pgz-farmbreakout/levels"));

    QmlApplicationViewer viewer;

    viewer.setViewport(new QGLWidget());
    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationLockLandscape);
    viewer.rootContext()->setContextProperty("LevelLoader", &loader);
    viewer.rootContext()->setContextProperty("Helper", &helper);
    viewer.rootContext()->setContextProperty("LevelPackModel", &levelPacks);

    viewer.engine()->addImportPath(QString("/opt/qtm12/imports"));

    viewer.setResizeMode(QDeclarativeView::SizeRootObjectToView);
    viewer.setGeometry(100, 100, 640, 320);

    viewer.setMainQmlFile(QLatin1String("qml/pgz-farmbreakout/main.qml"));
    viewer.showExpanded();

    return app.exec();
}
