#include "trailmainmenu.h"
#include <qlayout.h>
#include <QPushButton>
#include <QMessageBox>
#include "trailinterface.h"
#include <QDebug>

TrailMainMenu::TrailMainMenu(TrailInterface* interface, QWidget *parent) :
    QWidget(parent)
{
    qDebug() << "TrailMainMenu::TrailMainMenu";
    m_interface = interface;
    m_layout = new QVBoxLayout();

    m_recordTrip = new QPushButton(tr("Record New Trip"));
    m_createTrip = new QPushButton(tr("Create Trip"));
    m_myTrips = new QPushButton(tr("My Trips"));
    m_search = new QPushButton(tr("Search"));

#ifdef Q_OS_SYMBIAN
    forceButtonColor(m_recordTrip, Qt::black);
    forceButtonColor(m_createTrip, Qt::black);
    forceButtonColor(m_myTrips, Qt::black);
#endif

    m_layout->addWidget(m_recordTrip);
    m_layout->addWidget(m_createTrip);
    m_layout->addWidget(m_myTrips);
    m_layout->addWidget(m_search);

    m_layout->addStretch();

    connect(m_myTrips, SIGNAL(clicked()), this, SLOT(slotMyTripsClicked()));
    connect(m_recordTrip, SIGNAL(clicked()), this, SLOT(slotRecordTripClicked()));
    connect(m_createTrip, SIGNAL(clicked()), this, SLOT(slotCreateTripClicked()));
    connect(m_search, SIGNAL(clicked()), this, SLOT(slotSearchClicked()));

    setLayout(m_layout);
}

void TrailMainMenu::slotMyTripsClicked()
{
    m_interface->trips(m_interface->currentUser(), m_interface->currentPassword(), m_interface->currentUserId());
}

void TrailMainMenu::slotRecordTripClicked()
{
   emit navigateRecordTrip();
}

void TrailMainMenu::slotCreateTripClicked()
{
    emit navigateCreateTrip();
}

void TrailMainMenu::slotSearchClicked()
{
    emit navigateSearch();
}

