#ifndef TRAILLOGIN_H
#define TRAILLOGIN_H

#include <QWidget>
class QLineEdit;
class QPushButton;
class QVBoxLayout;
class QHBoxLayout;
class QCheckBox;

class TrailInterface;

class TrailLogin : public QWidget
{
Q_OBJECT
public:
    explicit TrailLogin(TrailInterface*, QWidget *parent = 0);

private:
    TrailInterface* m_interface;

    QLineEdit *m_user;
    QLineEdit *m_pass;
    QPushButton *m_loginButton;
    QCheckBox *m_remember;

    QVBoxLayout *m_layout;
    QHBoxLayout *m_btnLayout;

signals:
    void loggedIn();

private slots:
    void slotLoginClicked();
    void slotLoginReceived(long id);
};

#endif // TRAILLOGIN_H
