#include "trailtripslist.h"
#include "trailinterface.h"
#include <qlayout.h>
#include <QPushButton>
#include <QVariant>
#include <QLabel>
#include <qdebug.h>
#include <QApplication>
#include <QDesktopWidget>
#include <QListView>

#include "TripDelegate.h"

TrailTripsList::TrailTripsList(TrailInterface* interface, QWidget *parent) :
    QWidget(parent)
{
    m_interface = interface;
    m_layout = new QVBoxLayout(this);

    m_tripList = new QListView(this);
    m_tripList->setAlternatingRowColors(true);
    m_tripList->setWordWrap(true);
    m_tripList->setModel(m_interface);
    m_tripList->setItemDelegate(new TripDelegate(this));

    m_layout->addWidget(m_tripList);

    setLayout(m_layout);

    connect(m_tripList, SIGNAL(activated(QModelIndex)), this, SLOT(slotItemActivated(QModelIndex)));
}

void TrailTripsList::slotItemActivated(const QModelIndex &idx)
{
    emit(viewTrip(idx.row()));

}

