#ifndef S60TRAIL_H
#define S60TRAIL_H

#include <QWidget>
#include <QStack>

#include "trailinterface.h"

class QVBoxLayout;
class QHBoxLayout;
class QStackedWidget;
class QAction;
class QScrollArea;
class QToolButton;

class TrailLogin;
class TrailMainMenu;
class TrailTripsList;
class TrailTripView;
class TrailGPXRecorder;
class TrailCreateTrip;
class TrailTripSearch;
class TrailGPXView;

class S60Trail : public QWidget
{
    Q_OBJECT

public:
    explicit S60Trail(QWidget *parent = 0);
    ~S60Trail();

private:
    QVBoxLayout *m_layout;
    QHBoxLayout *m_titleLayout;
    QStackedWidget *m_stack;
    QScrollArea *m_viewTripScroll;
    QScrollArea *m_createTripScroll;
    QToolButton *m_backButton;

    TrailLogin *m_login;
    TrailMainMenu *m_menu;
    TrailTripsList *m_mytrips;
    TrailTripView *m_tripview;
    TrailGPXRecorder *m_gpxrecorder;
    TrailCreateTrip *m_createtrip;
    TrailTripSearch *m_tripsearch;
    TrailGPXView *m_gpxMapView;

    QStack<QWidget*> m_previous;
    QPixmap *m_logo;

#ifdef Q_OS_SYMBIAN
    QProgressDialog *m_progress;
#endif
    TrailInterface m_interface;

    QAction *m_backAction;
    void toggleRightSoftKey( bool back, QWidget* focusWidget );

    void showBusyIndicator();
    void hideBusyIndicator();

private slots:

    void slotBusy(bool);

    void slotLoggedIn();
    void slotGotTrips(bool);
    void slotBack();
    void slotViewTrip(int);
    void slotRecordTrip();
    void slotCreateTrip();
    void slotSearch();
    void slotViewMap();

};

#endif // S60TRAIL_H
