#ifndef TRAILTRACKMODEL_H
#define TRAILTRACKMODEL_H

#include <QModelIndex>
#include <QtLocation/QGeoPositionInfo>
#include <QtLocation/QGeoPositionInfoSource>
#include <QList>

using namespace QtMobility;

class TrailTrackModel : public QAbstractTableModel
{
Q_OBJECT
public:
    explicit TrailTrackModel(QObject* parent = 0);
    virtual QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const;
    virtual int columnCount(const QModelIndex& parent = QModelIndex()) const;
    virtual int rowCount(const QModelIndex& parent = QModelIndex()) const;
    virtual QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
    virtual Qt::ItemFlags flags(const QModelIndex &index) const;

    virtual ~TrailTrackModel();
    
    QtMobility::QGeoPositionInfo &currentPosition();
    void setRecord(bool);
    void clear();
    QString toText();
    
private:
    QList<QtMobility::QGeoPositionInfo> m_track;
    //QtMobility::QGeoPositionInfoSource *m_location;
    
    QtMobility::QGeoPositionInfo m_currentPosition;
    
    bool m_recording;
    
public slots:
    void positionUpdated(const QGeoPositionInfo&);
};

#endif // TRAILTRACKMODEL_H
