#ifndef MEASUREMENT_H
#define MEASUREMENT_H
#include <QObject>
#include <QString>
#include <QFile>
#include <QList>
#include <QMap>

//! Measurement class.
/*!
  This class saves the measured data
*/
class Measurement : public QObject
{
    Q_OBJECT
public:
    //! This method returns instance of this object.
    /*!
      Create new instance if there's no existing one.
      Otherwise return the old one.
      \return self
    */
    static Measurement *instance();

    //! This method return a list of all saved history
   /*! \return list of allValues */
    QList<QMap<QString, QString> > getValues();

    //! This method saves collected data
    /*! \param QList<QString> of one measurement values */
    void saveData(QList<QString>);

    void clearHistory();

private:
    //! Constructor
    Measurement();

    //! Store the instance.
    static Measurement *m_instance;

    //! Store measurement ID
    int id;
    //! Store systolic measurement
    int sys;
    //! Store diastolic measurement
    int dia;
    //! Store pulse
    int pulse;
    //! Store weight
    int weight;
    //! Store date
    QString date;
    //! Store time
    QString time;
    //! File to save data for sending
    QFile *CSVFile;
    //! File to save data for caching
    QFile *DataFile;
    //! Store a single measurement
    QMap<QString, QString> values;
    //! Store all measurements
    QList<QMap<QString, QString> > allValues;
};

#endif // MEASUREMENT_H
