#ifndef LINECHARTBUILDER_H
#define LINECHARTBUILDER_H

#include <QGraphicsScene>
#include <QGraphicsWidget>
#include "measurement.h"

//! LineChartBuilder class.
/*!
  This class creates the line
  graph from user's measurement history
*/
class LineChartBuilder : public QGraphicsScene
{
    Q_OBJECT
public:
    //! Constructor
    /*! \param parent QObject */
    explicit LineChartBuilder(bool drawSys = true, bool drawDia = true, bool drawPulse = true, bool drawWeight = true, QObject *parent = 0);

private:
    //! A pointer to Measurement class
    Measurement *measurement;
    //! This method draw's the grid
    int chartWidth;
    int columnWidth;

signals:

public slots:

};



#endif // LINECHARTBUILDER_H
