#ifndef EDITVIEW_H
#define EDITVIEW_H

#include <QWidget>
#include <measurement.h>
#include <QLineEdit>

//! EditView class.
/*!
  This class creates a view for
  comparing found values to original
  image and editing them
*/
class EditView : public QWidget
{
    Q_OBJECT
public:
    //! A constructor.
    /*! \param parent widget to return to. */
    explicit EditView(QWidget *parent = 0);

private:
    //! Pointer to measurent class.
    Measurement *measurement;

    QLineEdit *sysEdit;
    QLineEdit *diaEdit;
    QLineEdit *pulseEdit;
    QLineEdit *weightEdit;

private slots:
    //! Handle save button
    void saveButtonClicked();
    //! Handle reject button
    void rejectButtonClicked();

signals:
    //! Emits when reject button is clicked
    void trackAgain();

};

#endif // EDITVIEW_H
