#include "editview.h"
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QFormLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QPixmap>
#include <QPicture>
#include <QGridLayout>
#include <applicationmenu.h>
#include <QDebug>
#include <QList>
#include <QTime>
#include <QDebug>
#ifdef Q_WS_MAEMO_5
    #include <QtMaemo5>
#endif
#include <QSettings>


EditView::EditView(QWidget *parent) : QWidget(parent)
{
    //layout
    QVBoxLayout *layout = new QVBoxLayout();
    QGridLayout *gridLayout = new QGridLayout(this);
    QHBoxLayout *buttons = new QHBoxLayout();
    QFormLayout *form = new QFormLayout();

    //form labels
    QLabel *sys = new QLabel("SYS");
    QLabel *dia = new QLabel("DIA");
    QLabel *pulse = new QLabel("Pulse");
    QLabel *weight = new QLabel("Weight");

    //line edits
    sysEdit = new QLineEdit();
    diaEdit = new QLineEdit();
    pulseEdit = new QLineEdit();
    weightEdit = new QLineEdit();

    //buttons
    QPushButton *reject = new QPushButton("Track again");
    QPushButton *save = new QPushButton("Save");

    //temporary test image
    QPixmap pixmap(":/images/Omron-M2-Compact.jpg");
    QLabel *picture = new QLabel("");
    picture->setPixmap(pixmap);
    //add values to match temporary test image
    sysEdit->setText("118");
    diaEdit->setText("78");
    pulseEdit->setText("70");
    //get weight from previous time if set
    QSettings perChartSettings;
    if (perChartSettings.contains("weight"))
        weightEdit->setText(perChartSettings.value("weight").toString());

    buttons->addWidget(reject);
    buttons->addWidget(save);

    //setup form layout
    form->addRow(sys, sysEdit);
    form->addRow(dia, diaEdit);
    form->addRow(pulse, pulseEdit);
    form->addRow(weight, weightEdit);
    form->addRow(buttons);

    layout->addLayout(form);
    gridLayout->setColumnMinimumWidth(0, 350);
    gridLayout->addWidget(picture, 0, 0);
    gridLayout->addLayout(layout, 0, 1);

    //applicatoin menu
    ApplicationMenu *editMenu = new ApplicationMenu(this);

    setLayout(gridLayout);

    //connect buttons
    connect(reject, SIGNAL(clicked()), this, SLOT(rejectButtonClicked()));
    connect(save, SIGNAL(clicked()), this, SLOT(saveButtonClicked()));

}

void EditView::saveButtonClicked()
{
    //get current system time to match measurement
    QString time = QTime::currentTime().toString();
    time.chop(3);
    int day = QDate::currentDate().day();
    int month = QDate::currentDate().month();
    int year = QDate::currentDate().year();
    QString date = QString::number(day) + "/" + QString::number(month) + "/" + QString::number(year);
    //get measurement instance
    measurement = Measurement::instance();
    //save found information in a list
    QList<QString> inputData;
    inputData.append(date);
    inputData.append(time);
    inputData.append(sysEdit->text());
    inputData.append(diaEdit->text());
    inputData.append(pulseEdit->text());
    inputData.append(weightEdit->text());
    measurement->saveData(inputData);

    //save weight for next time
    QSettings perChartSettings;
    perChartSettings.setValue("weight", QVariant(weightEdit->text()));

    this->hide();
}

void EditView::rejectButtonClicked()
{
    //tell startview to open tracking again
    emit trackAgain();
    this->hide();
}


