#ifndef CAMERAVIEWFINDER_H
#define CAMERAVIEWFINDER_H

#include "camerathread.h"
#include "cameraoverlay.h"
#include "camerapanichandler.h"

#include <QVBoxLayout>
#include <QPalette>
#include <QLabel>
#include <QPainter>

//! CameraViewFinder class.
/*!
    This class creates a view for viewfinder.
*/

class CameraViewFinder : public QWidget
{
    Q_OBJECT
public:
    //! CameraViewFinder constructor
    CameraViewFinder(QWidget *parent = 0);
    //! CameraViewFinder destructor
    ~CameraViewFinder();
private:
    //! A pointer to CameraThread class
    CameraThread *cameraThread;
    //! A pointer to CameraOverlay class
    CameraOverlay *overlay;
    //! A pointer to CameraPanicHandler class
    CameraPanicHandler *panicHandler; 
    //! A layout for the viewfinder
    QGridLayout *gridLayout;
    //! A warning information if lens cover is shut
    QLabel *lensCoverWarning;
};

#endif // CAMERAVIEWFINDER_H
