#include "cameraviewfinder.h"

#include <QDebug>

CameraViewFinder::CameraViewFinder(QWidget *parent) : QWidget(parent)
{
    //create an overlay for displaying viewfinder frames
    overlay = new CameraOverlay(this);
    overlay->setFixedSize(640, 480);

    //create a thread that controls the camera and processes frames
    cameraThread = new CameraThread(overlay);

    //add overlay widget into layout
    gridLayout = new QGridLayout();
    gridLayout->addWidget(overlay);
    this->setLayout(gridLayout);
    
    panicHandler = new CameraPanicHandler();

    //set properties for the warning information
    lensCoverWarning = new QLabel("The lens cover appears shut.\n Please, open it to proceed.", overlay);
    lensCoverWarning->setGeometry(overlay->size().width(), overlay->size().height(), 400, 200);
    lensCoverWarning->setAutoFillBackground(true);
    lensCoverWarning->setAlignment(Qt::AlignCenter);
    lensCoverWarning->setVisible(CameraThread::lensCovered());
    
    connect(cameraThread, SIGNAL(panic(FCam::Event)), panicHandler, SLOT(handleEvent(FCam::Event)));
    connect(panicHandler, SIGNAL(eventHandled(FCam::Event)), cameraThread, SLOT(failGracefully()));
    connect(cameraThread, SIGNAL(lensCoverClosed()), lensCoverWarning, SLOT(show()));
    connect(cameraThread, SIGNAL(lensCoverOpened()), lensCoverWarning, SLOT(hide()));
    connect(cameraThread, SIGNAL(finished()), this, SLOT(deleteLater()));

    cameraThread->start();
}

CameraViewFinder::~CameraViewFinder()
{
    cameraThread->stop();
}
