# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtOpenGL import *
from table import Table
from scoreboard import ScoreBoard
import logging, os

class Main(QMainWindow):
    def __init__(self, parent = None, maemo = False):
        QMainWindow.__init__(self, parent)

        self.maemo = maemo

        if maemo: self.showMaximized()
        else: self.setGeometry(QRect(0, 0, 800, 480))

        self.centralwidget = QWidget(self)
        self.setCentralWidget(self.centralwidget)

        self.view = QGraphicsView(self.centralwidget)
        self.view.setFixedSize(self.geometry().width(), self.geometry().height())

        self.scene = QGraphicsScene()#(parent = self.tableView, maemo = maemo)
        self.view.setScene(self.scene)
        self.scene.setSceneRect(0, 0, self.view.geometry().width()-10, self.view.geometry().height()-10)
        self.table = Table(size = self.view.geometry().height(), maemo = maemo)
        self.connect(self.table , SIGNAL('gameOver'), self.gameOver)
        self.scene.addItem(self.table)
        self.table.setPos(0, 0)

        self.scoreBoard = ScoreBoard(width = self.geometry().width() - self.geometry().height(), height = self.geometry().height()-30)
        self.scoreBoard.setPos(self.geometry().height() - 20, 0)
        self.connect(self.table , SIGNAL('setScores'), self.scoreBoard.setScores)
        self.scene.addItem(self.scoreBoard)

        #self.scoreBoard = ScoreBoard(self.centralwidget, geometry = (self.geometry().height(), 0, self.geometry().width() - self.geometry().height(), self.geometry().height()))
        #self.connect(self.table , SIGNAL('setScores'), self.scoreBoard.setScores)
        #self.connect(self.table , SIGNAL('gameOver'), self.gameOver)


        """
        try:
            from PyQt4.QtOpenGL import QGLWidget
            glwidget = QGLWidget()
            if glwidget.isValid():
                self.tableView.setViewport(glwidget)
                #self.scoreBoard.setViewport(glwidget)
        except Exception, e:
            #logging.warning("OpenGL acceleration not available\n%s", e)
            pass
        """

        self.setWindowTitle("PeQersi")
        self.actions = dict()
        self.actions['history'] = QAction("&Save History", self)
        self.actions['newGame'] = QAction("&New Game", self)

        self.menu = self.menuBar().addAction(self.actions['newGame'])
        #self.menu = self.menuBar().addAction(self.actions['history'])

        #self.connect(self.actions['history'], SIGNAL('triggered()'), self.pickHistoryFile);
        self.connect(self.actions['newGame'], SIGNAL('triggered()'), self.table.newGame);

    def gameOver(self, scores):
        if scores[0] > scores[1]: status = 'You Won'
        elif scores[0] < scores[1]: status = 'You Lost'
        else: status = 'It\'s a tie'
        msgBox = QMessageBox()
        msgBox.setText('Game Over.\nScore:\nPlayer 1: %s\nPlayer 2: %s\n%s!\nPlay another game?' % (scores[0], scores[1], status))
        msgBox.setStandardButtons(QMessageBox.Yes | QMessageBox.No);
        ret = msgBox.exec_()
        if ret == QMessageBox.Yes:
            self.table.newGame()

    def pickHistoryFile(self):
        dialog = QFileDialog(self)
        dialog.setFileMode(QFileDialog.AnyFile)
        dialog.setDirectory(os.path.join(os.path.expanduser('~'), 'MyDocs'))
        if (dialog.exec_()):
            fileNames = list(dialog.selectedFiles())
            if fileNames:
                self.table.saveHistory(str(fileNames[0]))
