# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from player import Player
from random import randint

class ComputerMost(Player):
    def __init__(self, table):
        Player.__init__(self, table)
        QObject.__init__(self, table)

    def activated(self):
        if not self.active: return False
        moves = [ [m[0], len(m[1])] for m in self.table.getPosibleMoves().values()]
        moves.sort(key = lambda x: x[1])
        moves.reverse()
        moves = [ m for m in moves if m[1] == moves[0][1]]
        if len(moves) > 1: move = randint(0, len(moves) - 1)
        else: move = 0
        if self.table.pick(moves[move][0][0], moves[move][0][1]):
            return True

        return False