# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from score import Score

class ScoreBoard(QGraphicsView):
    def __init__(self, parent = None, geometry = None):
        QGraphicsView.__init__(self, parent = parent)
        self.scene = QGraphicsScene(self)
        if geometry:
            self.move(geometry[0], geometry[1])
            self.setFixedSize(geometry[2], geometry[3])
        self.setScene(self.scene)
        self.scene.setSceneRect(0, 0, self.geometry().width(), self.geometry().height())

        self.score = Score()
        self.score.setPos(0, 0)
        #self.score.setSize(self.geometry().width(), self.geometry().height()/2)
        self.scene.addItem(self.score)

    def setScores(self, scores = [2, 2]):
        self.score.setScores(*scores)

    def reset(self):
        self.score.setScores([2, 2])

