# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtOpenGL import *
from table import Table
from scoreboard import ScoreBoard
import logging, os

class Main(QMainWindow):
    def __init__(self, parent = None, maemo = False):
        QMainWindow.__init__(self, parent)

        self.maemo = maemo

        if maemo: self.showMaximized()
        else: self.setGeometry(QRect(0, 0, 800, 480))

        self.centralwidget = QWidget(self)
        self.setCentralWidget(self.centralwidget)

        self.tableView = QGraphicsView(self.centralwidget)
        self.tableView.setFixedSize(self.geometry().height(), self.geometry().height())

        self.table = Table(parent = self.tableView, maemo = maemo)
        self.tableView.setScene(self.table)

        self.scoreBoard = ScoreBoard(self.centralwidget, geometry = (self.geometry().height(), 0, self.geometry().width() - self.geometry().height(), self.geometry().height()))
        self.connect(self.table , SIGNAL('setScores'), self.scoreBoard.setScores)
        self.connect(self.table , SIGNAL('gameOver'), self.gameOver)

        """
        try:
            from PyQt4.QtOpenGL import QGLWidget
            glwidget = QGLWidget()
            if glwidget.isValid():
                self.tableView.setViewport(glwidget)
                #self.scoreBoard.setViewport(glwidget)
        except Exception, e:
            #logging.warning("OpenGL acceleration not available\n%s", e)
            pass
        """

        self.setWindowTitle("PeQersi")
        self.actions = dict()
        self.actions['history'] = QAction("&Save History", self)
        self.actions['newGame'] = QAction("&New Game", self)

        self.menu = self.menuBar().addAction(self.actions['newGame'])
        #self.menu = self.menuBar().addAction(self.actions['history'])

        self.connect(self.actions['history'], SIGNAL('triggered()'), self.pickHistoryFile);
        self.connect(self.actions['newGame'], SIGNAL('triggered()'), self.table.newGame);

    def gameOver(self, won = False):
        if  won: message = 'Game Over. You Won!'
        else: message = 'Game Over. You Lost!'
        msgBox = QMessageBox()
        msgBox.setText(message)
        msgBox.exec_()

    def pickHistoryFile(self):
        dialog = QFileDialog(self)
        dialog.setFileMode(QFileDialog.AnyFile)
        dialog.setDirectory(os.path.join(os.path.expanduser('~'), 'MyDocs'))
        if (dialog.exec_()):
            fileNames = list(dialog.selectedFiles())
            if fileNames:
                self.table.saveHistory(str(fileNames[0]))
