#ifndef FINGERBUTTONDIALOG_H
#define FINGERBUTTONDIALOG_H

#include <QtGui/QDialog>
#include <QSignalMapper>

namespace Ui {
    class FingerButtonDialog;
}

class FingerButtonDialog : public QDialog
{
    Q_OBJECT
public:
    FingerButtonDialog(QWidget *parent = 0);
    ~FingerButtonDialog();

    void setButtons(const QStringList& strings);
    QWidget* widgetAt(int i);

    int selectedIndex() const;

private slots:
    void clicked(int buttonindex);

protected:
    void changeEvent(QEvent *e);

private:
    int m_selection;
    Ui::FingerButtonDialog *m_ui;
    QVector<QWidget*> m_widgets;
    QSignalMapper* m_signalMapper;
};

#endif // FINGERBUTTONDIALOG_H
