#ifndef FILESYSTEMFEEDBUNDLE_H
#define FILESYSTEMFEEDBUNDLE_H

#include <QString>
#include <QVector>
#include "feedinterface.h"

class FilesystemFeedBundle;

class FilesystemFeed : public IFeed
{
public:
    FilesystemFeed();
    // IFeed
    void getEntries( QVector<FeedEntry>& entries) const;
    QString name() const;

    void setName(const QString& name);    

    void setFileName(const QString& fname);

    FilesystemFeedBundle* m_feedbundle;

private:
    QString m_name;
    QString m_filename;
};

class FilesystemFeedBundle : public IFeedBundle
{
public:
    FilesystemFeedBundle();
    ~FilesystemFeedBundle();
    // IFeed
    void getFeeds(QVector< IFeed* >& feeds);

    // own methods
    bool addPath(const QString& name);

private:
    QVector<FilesystemFeed*> m_feeds;
};

#endif // FILESYSTEMFEEDBUNDLE_H
