#ifndef DESIGN_SPEC_H
#define DESIGN_SPEC_H

#include <QString>

struct FeedEntry
{
public:
	QString title;
	QString author;
	QByteArray body;
	QString url;
};

// dumb feed iterator
class IFeedBundle
{

	// start iterating
	void start();
	// NULL when last
	// ownershop NOT transferred, objects guaranteed to be persistent
	virtual IFeed* next() = 0;
};

// interface
class IFeed
{
	QString name();
	// get
	virtual void getEntries( QList<FeedEntry>& entries) = 0;
};

// get stuff from penguintv sqlite store
class PenguinTvFeedBundle : public IFeedBundle
{

};

class PenguinTvFeed : public IFeed
{

};

// launchers needed for different browser launch methods
class IUrlHandler
{
	virtual void urlSelected(const QString& url) = 0;
}

// contains stackedwidget with feed list (list widget) + feed

class FeedreaderWidget : public QWidget
{
	void setModel(IFeedBundle*);
	// ....

};

#endif // DESIGN_SPEC_H
