#include "prtopstackedwidget.h"
#include <QEvent>
#include <QKeyEvent>
#include "prfeedview.h"
#include "prtextbody.h"
#include <QListWidget>
#include "prconst.h"
#include <QDebug>
#include <QSettings>
#include <QDesktopServices>
#include <QUrl>
#include <QTextBrowser>
#include <QFileInfo>
#include <QPushButton>

#include "feedinterface.h"
#include "feedrenderer.h"
#include "fingerbuttondialog.h"
#include "prappservices.h"
#include "textedithelper.h"


PrTopStackedWidget::PrTopStackedWidget(QWidget *parent, PrAppServices* appsrv) :
    QStackedWidget(parent), m_appSrv(appsrv), m_renderer(NULL)
{    
    m_FeedView = new PrFeedView(m_appSrv, this );
    m_TextBody = new PrTextBody(m_appSrv, this);
    //m_renderer = new TrivialFeedRenderer();

    this->addWidget(m_FeedView);
    this->addWidget(m_TextBody);

    connect(m_FeedView->listWidget(), SIGNAL(itemActivated(QListWidgetItem*)),this,SLOT(showFeed(QListWidgetItem*)));
    connect(m_FeedView->listWidget(), SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(showFeed(QListWidgetItem*)));
    connect(m_TextBody, SIGNAL(anchorClicked(const QUrl&)), this, SLOT(urlClicked(QUrl)));

    m_linksEnabled=false;
}

PrTopStackedWidget::~PrTopStackedWidget()
{
}

void PrTopStackedWidget::changeEvent(QEvent *e)
{
    QStackedWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        break;
    default:
        break;
    }
}

void PrTopStackedWidget::keyPressEvent(QKeyEvent *e)
{
    int scancode=e->nativeScanCode();
    if (scancode==TOGGLE_TEXT && m_TextBody->toPlainText().length()>0)
    {
        setCurrentWidget(m_TextBody);
        e->accept();
    }
    else
    {
        QStackedWidget::keyPressEvent(e);
    }
}

void PrTopStackedWidget::showFeed(QListWidgetItem* item)
{
    if ( m_currentItem != item )
    {
        const IFeed* feed = m_feedmap[item];

        QVector<FeedEntry> ents;
        feed->getEntries(ents);        
        m_renderer->renderEntries(ents, *m_TextBody);
        m_currentItem = item;
    }

    // xxx remove
#ifdef DUMMYTEST

    if (feedView->listWidget()->currentRow() == 0)
    {
        textBody->setHtml("<html><body><b>test1</b><br><a href=\"http://www.google.com\">google</a><br><img src=\"http://www.merriam-webster.com/art/med/skeleton.gif\">kuva<img></body></html>");
    }
    else
    {
        textBody->setHtml("<html><body><b>test2</b><br><a href=\"http://www.yahoo.com\">yahoo</a></body></html>");
    }

#endif
    setCurrentWidget(m_TextBody);
}

void PrTopStackedWidget::setFeedBundle(IFeedBundle* feeds)
{    
    m_feedbundle = feeds;
    QListWidget* w = m_FeedView->listWidget();
    w->clear();
    QVector<IFeed*> allfeeds;
    feeds->getFeeds(allfeeds);

    foreach (const IFeed* feed, allfeeds)
    {
        QListWidgetItem* lwi = new QListWidgetItem(feed->name(), w);
        w->addItem(lwi);
        m_feedmap[lwi] = feed;

    }

}

void PrTopStackedWidget::urlClicked(const QUrl& link )
{
    QString url = link.toString();
    qDebug() << url;

    // direct handling of local links


    FingerButtonDialog* dlg = new FingerButtonDialog();
    dlg->setWindowTitle(url);
    QStringList buttons;
    QString linkBtnText;

    if ( m_linksEnabled )
    {
        linkBtnText="Disable Links";
    }
    else
    {
        linkBtnText="Enable Links";
    }
    buttons << "Browser" << "Tear" << "Stash" << linkBtnText << "Back" << "Go";

    dlg->setButtons(buttons);


    // only allow "Go" for local files
    QUrl baseurl = renderer()->baseUrl();
    bool goAllowed = false;
    if (!baseurl.isEmpty())
    {
        QString lfile = link.toLocalFile();
        if (QFileInfo(lfile).isFile())
        {
            goAllowed = true;

        }
    }

    QPushButton* goBtn = qobject_cast<QPushButton*>(dlg->widgetAt(5));
    if (!goAllowed)
        goBtn->setEnabled(false);

    QFileInfo tearpth("/usr/bin/tear");
    if (!tearpth.isExecutable())
    {
        qobject_cast<QPushButton*>(dlg->widgetAt(1))->setEnabled(false);
    }



    int ret = dlg->exec();
    int sel = dlg->selectedIndex();
    delete dlg;
    if (ret == QDialog::Rejected)
    {
        return;
    }
    //qDebug() << "sel" << sel;

    switch (sel)
    {
        case 0:
        {
            m_appSrv->settings()->setValue("browser/kind", "default");
            m_appSrv->launchUrl(url);

            //lQDesktopServices::openUrl(link);
            break;
        }
        case 1:
        {
            m_appSrv->settings()->setValue("browser/kind", "tear");
            m_appSrv->launchUrl(url);
            // yeah, would have to go through dbus
            break;
        }
        case 2:
        {
            m_urlList.append(url.toAscii());
            m_FeedView->enableStash();
            break;
        }
        case 3:
        {
            m_linksEnabled=!m_linksEnabled;
            break;
        }

        case 4:
        {
            bodyWdg()->backward();
            break;

        }
        case 5:
        {
            bodyWdg()->setSource(link);
            TextEditHelper(*bodyWdg()).cursorToCenter();
            break;
        }
        default:
        {
            // pass
        }
    }
}

PrTextBody* PrTopStackedWidget::bodyWdg()
{
    return m_TextBody;
}

PrFeedView* PrTopStackedWidget::feedWdg()
{
    return m_FeedView;
}

QStringList PrTopStackedWidget::urlList()
{
    return m_urlList;
}

bool PrTopStackedWidget::linksEnabled()
{
    return m_linksEnabled;
}

void PrTopStackedWidget::setRenderer(FeedRenderer* renderer)
{
    m_renderer = renderer;
}
