#include "penguintvfeedbundle.h"

#include <QMessageBox>
#include <QSqlDatabase>
#include <QSqlError>
#include <QSqlQuery>
#include <QDebug>
#include <QVariant>
#include <QFileInfo>

static QString getDbPath()
{
    // xxx safe to use QDesktopServices here? depends on ptv...
    QString res= getenv("HOME");
    res.append("/.penguintv/penguintv4.db");
    return res;
}

bool
PenguinTvFeedBundle::readDatabase()
{
    // xxx factor to "openDatabase"
    m_db = QSqlDatabase::addDatabase("QSQLITE");
    QString pth = getDbPath();
    QFileInfo fi(pth);
    if (!fi.exists())
    {
	return false;
    }

    m_db.setDatabaseName(pth);

    if (!m_db.open()) {
	return false;

    }

    QSqlQuery query("SELECT url, title, description, id FROM feeds");

    while (query.next()) {

        QString url = query.value(0).toString();
        QString title = query.value(1).toString();
        QString desc = query.value(2).toString();
        int fid = query.value(3).toInt();
        PenguinTvFeed* feed = new PenguinTvFeed;
        feed->setName(title);
        feed->m_feedid = fid;
        m_feeds.append(feed);
     }

    return true;
}

PenguinTvFeedBundle::PenguinTvFeedBundle()
{
    //readDatabase();
}

PenguinTvFeedBundle::~PenguinTvFeedBundle()
{
    foreach (PenguinTvFeed* f, m_feeds)
    {
        delete f;
    }
    m_feeds.clear();

}


void PenguinTvFeedBundle::getFeeds(QVector< IFeed* >& feeds)
{
    foreach( IFeed* feed, m_feeds)
    {
        feeds.append(feed);
    }

}

void PenguinTvFeed::getEntries( QVector<FeedEntry>& entries) const
{
    entries.clear();

    QSqlQuery q("SELECT title, creator, description, link from entries where feed_id = (?) order by date desc");

    q.addBindValue(m_feedid);
    q.exec();
    while (q.next())
    {
        QString title = q.value(0).toString();
        QString creator = q.value(1).toString();
        QString desc = q.value(2).toString();
        QString link = q.value(3).toString();
        FeedEntry fe;
        fe.m_author = creator;
        fe.setBodyString(desc);

        fe.m_title = title;
        fe.m_url = link;
        fe.m_contenttype = "text/html";
        entries.append(fe);

    }

    /*

      Schema:

            (
                    id INTEGER PRIMARY KEY,
            feed_id INTEGER UNSIGNED NOT NULL,
            title TEXT,
            creator TEXT,
            description TEXT,
            fakedate DATE,
            date DATE,
            guid TEXT,
            link TEXT,
            keep INTEGER,
                    read INTEGER NOT NULL,
                    hash TEXT
    */

}

void PenguinTvFeed::setName(const QString& name)
{
    m_name = name;
}

QString PenguinTvFeed::name() const
{
    return m_name;
}
