#include <QtGui>

#include "feedinterface.h"
#include "penguintvfeedbundle.h"
#include "filesystemfeedbundle.h"

#include "mainwindow.h"
#include "prtopstackedwidget.h"
#include "prtextbody.h"
#include "feedrenderer.h"
#include "prfeedview.h"

#include <QSettings>
#include <QApplication>


MainWindow::MainWindow()
{

    // ctrl + / ctrl - on pc, zoom hw keys on diablo
    //QShortcut* zIn = new QShortcut(QKeySequence::ZoomIn, this);
    //QShortcut* zOut = new QShortcut(QKeySequence::ZoomOut, this);

    QShortcut* zIn = new QShortcut(QKeySequence("a"), this);
    QShortcut* zOut = new QShortcut(QKeySequence("z"), this);

    connect(zIn, SIGNAL(activated()), this, SLOT(zoomInPressed()));
    connect(zOut, SIGNAL(activated()), this, SLOT(zoomOutPressed()));
    zIn->setEnabled(true);
    zOut->setEnabled(true);

    m_topWdg = new PrTopStackedWidget(this, this);
    setCentralWidget(m_topWdg);
    m_settings = new QSettings("Digia", "PenguinReader");

    createActions();
    createMenus();

    if (qApp->arguments().count() > 1)
    {
        QTimer::singleShot(0, this, SLOT(setupFilesystemFeeds()));
    }
    else
    {
        QTimer::singleShot(0, this, SLOT(setupPenguinTvFeeds()));
    }


}

MainWindow::~MainWindow()
{
    delete m_feedBundle;
    delete m_settings;
}


void MainWindow::about()
{
   QMessageBox::about(this, tr("About Application"),
            tr("<b>PenguinReader</b> is an RSS feed viewer, to be used in conjunction with PenguinTV. Development sponsored by Digia Inc."));
}

void MainWindow::createActions()
{
    aboutAct = new QAction(tr("&About"), this);
    aboutAct->setStatusTip(tr("Show the application's About box"));
    connect(aboutAct, SIGNAL(triggered()), this, SLOT(about()));

    aboutQtAct = new QAction(tr("About &Qt"), this);
    aboutQtAct->setStatusTip(tr("Show the Qt library's About box"));
    connect(aboutQtAct, SIGNAL(triggered()), qApp, SLOT(aboutQt()));

    helpAct = new QAction(tr("&Help"), this);

    connect(helpAct, SIGNAL(triggered()), this, SLOT(showHelp()));
}

void MainWindow::createMenus()
{

    helpMenu = menuBar()->addMenu(tr("&Help"));
    helpMenu->addAction(aboutAct);
    helpMenu->addAction(aboutQtAct);
    helpMenu->addAction(helpAct);

}

void MainWindow::changeOrientation()
{
}


void MainWindow::zoomInPressed()
{
    m_topWdg->bodyWdg()->zoomIn();

}
void MainWindow::zoomOutPressed()
{
    m_topWdg->bodyWdg()->zoomOut();
}

void MainWindow::doReadDatabase()
{
    bool ok = static_cast<PenguinTvFeedBundle*>(m_feedBundle)->readDatabase();
    if (!ok)
    {
        QMessageBox::warning(NULL, tr("PenguinTV"), tr("PenguinTV feeds not found. Install PenguinTV and add some feeds, or specify files on command line."));

    }
    else
    {
        m_topWdg->setFeedBundle(m_feedBundle);
    }
}

void MainWindow::showHelp()
{
    QMessageBox::about(this, tr("Help"), tr("Press top/bottom edge to scroll. Bottom left exits body view. a/z zooms."));

}

QSettings* MainWindow::settings()
{
    return m_settings;
}

void MainWindow::launchUrl(const QUrl& url)
{
    QString kind = settings()->value("browser/kind", "default").toString();
    if (kind == "default")
    {
        QDesktopServices::openUrl(url);
    } else if (kind == "tear")
    {
        // xxx todo: switch to dbus launch eventually
        QByteArray cmd = "/usr/bin/tear \"" + url.toString().toAscii() + "\" &";
        // ignore return value, for now
        int r = system(cmd);
        if (r==-1)
        {
            qDebug() << "system() failed on launching tear";

        }
    }
}

void MainWindow::setupPenguinTvFeeds()
{
    m_feedBundle = new PenguinTvFeedBundle;
    FeedRenderer* renderer = new TrivialFeedRenderer();
    m_topWdg->setRenderer(renderer);

    QTimer::singleShot(0, this, SLOT(doReadDatabase()));
}


void MainWindow::setupFilesystemFeeds()
{
    FilesystemFeedBundle* ffb = new FilesystemFeedBundle;
    m_feedBundle = ffb;
    QStringList files = qApp->arguments();
    // ingore arg[0]
    files.pop_front();
    int count = 0;
    foreach (const QString& s, files)
    {
        ffb->addPath(s);
        ++count;
    }

    m_renderer = new FileContentRenderer();
    m_topWdg->setRenderer(m_renderer);

    m_topWdg->setFeedBundle(m_feedBundle);
    if (count == 1)        
    {
        // slight violation of encupsulation, but nobody cares about MainWindow anyway
        QListWidget* wdg = m_topWdg->feedWdg()->listWidget();
        QListWidgetItem* first = wdg->item(0);
        m_topWdg->showFeed(first);

    }
}
