#ifndef FEEDRENDERER_H
#define FEEDRENDERER_H

#include "feedinterface.h"
#include <QUrl>


class QTextEdit;

class FeedRenderer
{
public:    
    virtual void renderEntries(const QVector< FeedEntry >& entries, QTextEdit& editor) = 0;
    // will be set to base url of rendered item - only implement if necessary
    virtual QUrl baseUrl();
    virtual ~FeedRenderer();
};

class TrivialFeedRenderer : public FeedRenderer
{
public:
    TrivialFeedRenderer();
    void renderEntries(const QVector< FeedEntry >& entries, QTextEdit& editor);    
};

class FileContentRenderer : public FeedRenderer
{
public:
    FileContentRenderer();
    void renderEntries(const QVector< FeedEntry >& entries, QTextEdit& editor);
    QUrl baseUrl();
    ~FileContentRenderer();

private:
    QUrl m_baseUrl;  
};


#endif // FEEDRENDERER_H
