#ifndef FEEDINTERFACE_H
#define FEEDINTERFACE_H

#include <QString>

class FeedEntry
{
public:
    QString getBody() const;
    void setBodyString(QString body);
    void setBodyFile(QString fname);

    QString m_title;
    QString m_author;
    QString m_url;

    QString m_contenttype;

    // if bodyfile is empty, 'body' contains the contents
    // xxx make abstract?
    QString m_body;
    QString m_bodyfile;
    // text/plain or text/html, for now

};


// interface
class IFeed
{
public:
    virtual QString name() const = 0;
    // get
    virtual void getEntries( QVector<FeedEntry>& entries) const = 0;

    virtual ~IFeed();



};


class IFeedBundle
{
public:
    virtual void getFeeds(QVector< IFeed* >& feeds) = 0;
    virtual ~IFeedBundle();
};


#endif // FEEDINTERFACE_H
