/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Marcos Morais <morais@dee.ufcg.edu.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef __NM_WLAN_SETUP_H__
#define __NM_WLAN_SETUP_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "nm_conn_widget.h"

G_BEGIN_DECLS

#define NM_WLAN_DEFAULT_IP          "192.168.4.15"
#define NM_WLAN_DEFAULT_GATEWAY     "192.168.4.14"
#define NM_WLAN_DEFAULT_MASK        "255.255.255.0"
#define NM_WLAN_DEFAULT_ESSID       "devel_adhoc"
#define NM_WLAN_DEFAULT_TYPE        "WLAN_ADHOC"
#define NM_WLAN_DEFAULT_IPV4_TYPE   "STATIC"
#define NM_WLAN_DEFAULT_HIDDEN      "false"
#define NM_WLAN_DEFAULT_NAME        "devel_adhoc"
#define NM_WLAN_DEFAULT_SECURITY    "NONE"

#define NM_GCONF_DIR_WLAN               "/system/osso/connectivity/IAP/devel_adhoc"
#define NM_GCONF_KEY_WLAN_IP            NM_GCONF_DIR_WLAN "/ipv4_address"
#define NM_GCONF_KEY_WLAN_GATEWAY       NM_GCONF_DIR_WLAN "/ipv4_gateway"
#define NM_GCONF_KEY_WLAN_MASK          NM_GCONF_DIR_WLAN "/ipv4_netmask"
#define NM_GCONF_KEY_WLAN_ESSID         NM_GCONF_DIR_WLAN "/wlan_ssid"
#define NM_GCONF_KEY_WLAN_TYPE          NM_GCONF_DIR_WLAN "/type"
#define NM_GCONF_KEY_WLAN_IPV4_TYPE     NM_GCONF_DIR_WLAN "/ipv4_type"
#define NM_GCONF_KEY_WLAN_HIDDEN        NM_GCONF_DIR_WLAN "/wlan_hidden"
#define NM_GCONF_KEY_WLAN_NAME          NM_GCONF_DIR_WLAN "/name"
#define NM_GCONF_KEY_WLAN_SECURITY      NM_GCONF_DIR_WLAN "/wlan_security"

#define NM_WLAN_COMBO_DEFAULT           0
#define NM_WLAN_COMBO_MANUAL            1

#define NM_WLAN_SETUP_TYPE              (nm_wlan_setup_get_type ())
#define NM_WLAN_SETUP(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_WLAN_SETUP_TYPE, NmWlanSetup))
#define NM_WLAN_SETUP_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), NM_WLAN_SETUP_TYPE, NmWlanSetupClass))
#define IS_NM_WLAN_SETUP(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_WLAN_SETUP_TYPE))
#define IS_NM_WLAN_SETUP_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_WLAN_SETUP_TYPE))
#define NM_WLAN_SETUP_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_WLAN_SETUP_TYPE, NmWlanSetupClass))

typedef struct _NmWlanSetup      NmWlanSetup;
typedef struct _NmWlanSetupClass NmWlanSetupClass;

struct _NmWlanSetupClass
{
    NmConnWidgetClass parent_class;
};

struct _NmWlanSetup
{
    NmConnWidget parent;
};

GType       nm_wlan_setup_get_type (void);
GtkWidget*  nm_wlan_setup_new      (gchar *env);
void nm_wlan_setup_enable (NmWlanSetup *self, gboolean enable);
gboolean nm_wlan_setup_is_enabled (NmWlanSetup *self);
gboolean wlan_setup_check_enabled (NmWlanSetup *self);
void nm_wlan_setup_fill_widget(NmWlanSetup *);
gboolean nm_wlan_setup_apply_changes(NmConnWidget *);
gboolean nm_wlan_setup_activate_environment (gchar *);
void nm_wlan_setup_save_changes (NmWlanSetup *);

G_END_DECLS

#endif
